%\name{equateModels}
\name{Ops.SBMLR}
%\alias{equateModels}
\alias{Ops.SBMLR}
%\alias{==}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Check the equality of the species and reactions of two SBMLR models}
\description{
  This function tests the equivalence of two models with respect to the species and reaction data frames generated by summary.  
}
\usage{
\method{Ops}{SBMLR}(e1,e2)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{e1}{The first of the two model objects of class SBML which are to be compared.}
  \item{e2}{The second model object.}
%  \item{\dots}{ For compatibility with \code{==} of the base package.}
 }
% \details{no details}

\value{ A list containing the following two boolean dataframes 
 \item{species}{ The equality of species information tabularized  as a data frame.}
  \item{reactions}{ The equality of reaction information tabularized as a dataframe.}
}

\author{ Tom Radivoyevitch }

\seealso{ \code{\link{summary.SBMLR}}  }
\examples{
library(SBMLR)  
curto1=readSBMLR(file.path(system.file(package="SBMLR"), "models/curto.r"))  
curto2=readSBML(file.path(system.file(package="SBMLR"), "models/curto.xml"))  
curto1==curto2

}
\keyword{ math }% at least one, from doc/KEYWORDS
