% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.utilities.R
\name{downloadSbgnFile}
\alias{downloadSbgnFile}
\title{Download pre-generated SBGN-ML file from GitHub}
\usage{
downloadSbgnFile(pathway.id, download.folder = "./")
}
\arguments{
\item{pathway.id}{A character string. The ID of pathway. For accepted pathway IDs, please check \code{data('pathways.info')}. IDs are in column 'pathway.id' (pathways.info[,'pathway.id'])}

\item{download.folder}{A character string. Default: "./". The output folder to store created SBGN-ML files.}
}
\value{
A vector of character strings. The path to the created SBGN-ML files.
}
\description{
This function will download a SBGN-ML file from our pre-collected SBGN-ML files given the 'pathway.id' argument.
}
\examples{
data("pathways.info")
data("sbgn.xmls")
input.sbgn <- downloadSbgnFile(pathway.id = pathways.info[1,'pathway.id'],
                              download.folder = './')
}
