% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqcQA-methods.R
\name{rqcQA}
\alias{rqcQA}
\alias{rqcQA,list-method}
\alias{rqcQA,character-method}
\alias{rqcQA,BamFile-method}
\alias{rqcQA,FastqFile-method}
\title{Quality Assessment Rqc function}
\usage{
rqcQA(
  x,
  sample = TRUE,
  n = 1e+06,
  group = rep("None", length(x)),
  top = 10,
  pair = seq_along(x),
  ...
)

\S4method{rqcQA}{list}(x, sample, n, group, top, pair, workers = multicoreWorkers())

\S4method{rqcQA}{character}(
  x,
  sample = TRUE,
  n = 1e+06,
  group = rep("None", length(x)),
  top = 10,
  pair = seq_along(x),
  workers = multicoreWorkers()
)

\S4method{rqcQA}{BamFile}(x, sample, n, group, top, pair)

\S4method{rqcQA}{FastqFile}(x, sample, n, group, top, pair)
}
\arguments{
\item{x}{input file(s)}

\item{sample}{It reads a random sample from files if this parameter is TRUE.}

\item{n}{Number of sequences to read from each input file.  This represents
sample size if 'sample' parameter is TRUE, if not represents the chunk size
to read on each iteration.  Default is read a sample of one million
sequences from each input file.}

\item{group}{group name for each input file.}

\item{top}{number of top over-represented reads. Default is 10 reads.}

\item{pair}{combination of files for paired-end reads. By default, all input 
files are treated as single-end. For paired-end, please define a vector of
numbers where two index with the same value represent a pair. Examples, 
single-end \code{c(1,2,3,4)} and paired-end \code{c(1,1,2,2)}.}

\item{...}{other parameters}

\item{workers}{number of parallel workers}
}
\value{
A named list of \code{RqcResultSet} objects, each one represents a
file.
}
\description{
Process a set of files and returns a list of quality control data.  Files
must be FASTQ format, compressed or not.
}
\details{
Input files are read using \code{FastStreamer} and \code{FastSampler}
classes of \code{\link{ShortRead}} package.  Process multiple files in
parallel using \code{\link{bplapply}} function of \code{\link{BiocParallel}}
package.
}
\section{Methods (by class)}{
\itemize{
\item \code{list}: process a list of \code{\link[ShortRead]{FastqFile}} and
\code{\link[Rsamtools]{BamFile}} objects.

\item \code{character}: automatically detects file format 
(using \code{\link{detectFileFormat}} function) of input files then process.

\item \code{BamFile}: process only one BAM file.

\item \code{FastqFile}: process only one FASTQ file.
}}

\examples{

checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
rqcReadQualityPlot(rqcResultSet)

}
\seealso{
\code{\link{rqc}}
}
\author{
Welliton Souza
}
