% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{summary,Rnits-method}
\alias{summary,Rnits-method}
\title{Summary of fit}
\usage{
\S4method{summary}{Rnits}(object, top = 48, fdr = NULL, plot = FALSE,
  sort.by = "p-value")
}
\arguments{
\item{object}{\code{\linkS4class{Rnits}} object on which \code{fit} has been applied}

\item{top}{Display results for top N genes/probes. Default \code{50}}

\item{fdr}{Display results for genes/probes less than FDR (\%) cutoff (if provided). Overrides \code{top} argument}

\item{plot}{If \code{TRUE}, plot histogram of p-values}

\item{sort.by}{Sort top results by either \code{p-value} or \code{FDR}}
}
\value{
A table of top genes/profiles listing the ratio statistics, p-values, q-values and  cluster information.
}
\description{
Summarize top genes or probes from Rnits \code{fit} method
}
\examples{
# load pre-compiled expressionSet object for Ronen and Botstein yeast  chemostat data
data(yeastchemostat)
rnitsobj = build.Rnits(yeastchemostat, logscale = TRUE, normmethod = 'Between')
\dontrun{
# Fit model using gene-level summarization
rnitsobj <- fit(rnitsobj, gene.level = TRUE, clusterallsamples = FALSE)

# Get summary of top genes
summary(rnitsobj, FDR = 5)

}
}

