% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{getCID}
\alias{getCID}
\alias{getCID,Rnits-method}
\alias{getCID,character,ANY-method}
\title{Cluster IDs of probes/genes from fitted \code{\linkS4class{Rnits}}}
\usage{
getCID(object)

\S4method{getCID}{Rnits}(object)
}
\arguments{
\item{object}{\code{\linkS4class{Rnits}}}
}
\value{
A vector of cluster IDs corresponding to gene/probe names
}
\description{
Retrieve cluster IDs of probes/genes from fitted \code{\linkS4class{Rnits}} object after \code{fit} has been run.
}
\details{
If \code{cluster = False} during fitting, a vector of \code{1s} will be returned.
}
\examples{
# load pre-compiled expressionSet object for Ronen and Botstein yeast  chemostat data
data(yeastchemostat)
rnitsobj = build.Rnits(yeastchemostat, logscale = TRUE, normmethod = 'Between')
\dontrun{
# Fit model using gene-level summarization
rnitsobj <- fit(rnitsobj, gene.level = TRUE, clusterallsamples = FALSE)

# Get cluster IDs from fitted model
cid <- getCID(rnitsobj)
}
}

