% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{rnb.region.types.for.analysis}
\alias{rnb.region.types.for.analysis}
\title{rnb.region.types.for.analysis}
\usage{
rnb.region.types.for.analysis(rnb.set)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}.}
}
\value{
List of all region types to be analyzed in the current dataset in the form of a \code{character} vector.
}
\description{
Identifies the region types that are summarized by the given dataset and pointed to for analysis.
}
\details{
This function intersects the value of the analysis option \code{"region.types"} with the region types that are
summarized in the provided dataset. In case the option's value is \code{NULL}, this function returns all summarized
region types in \code{rnb.set}.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
"promoters" \%in\% rnb.region.types.for.analysis(rnb.set.example)
}
}
\seealso{
\code{\link{rnb.getOption}} for checking the value of the \code{"region.types"} option;
  \code{\link[=summarized.regions,RnBSet-method]{summarized.regions}} for obtaining the region types summarized in a
  dataset
}
\author{
Yassen Assenov
}
