% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingUtils.R
\name{rnb.plot.pheno.categories}
\alias{rnb.plot.pheno.categories}
\title{rnb.plot.pheno.categories}
\usage{
rnb.plot.pheno.categories(
  annotations,
  columns = NULL,
  fileprefix = "barchart_pheno",
  report = NULL,
  color.values = rnb.getOption("colors.category")
)
}
\arguments{
\item{annotations}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}, or its sample
annotations in the form of a \code{data.frame}. If this parameter is a dataset, the annotation
information is extracted using the method \code{\link[=pheno,RnBSet-method]{pheno}}.}

\item{columns}{Optional; predefined column names (in the form of a \code{character} vector) or indices (an
\code{integer} vector) to consider. All other columns in the annotation table will be ignored.}

\item{fileprefix}{\code{character} vector with one element storing the file name prefix of the output files,
without the extension. Only a limited set of symbols is allowed to be used in this prefix.}

\item{report}{Report to contain the generated plots. If specified, this must be an object of type
\code{\linkS4class{Report}}.}

\item{color.values}{Non-empty \code{character} vector containing the color scheme to be mapped to the categories
defined in the annotation table. Colors are recycled if necessary, that is, if the length of this
vector is smaller than the number of categories in a trait.}
}
\value{
List of report plots. The names in this list are the column names in the annotation table that were selected
        for visualization. In case no suitable categorical traits are found among the provided annotations, this
        function returns an empty list.
}
\description{
Generates bar charts summarizing the categorical traits in a sample annotation table.
}
\details{
This function identifies the traits that define sample subgroups and then generates one report plot per
trait. Every report plot consists of two files. File names are formed by appending an index and file extension to
\code{fileprefix}. Thus, the suffixes appended are \code{"_1.pdf"}, \code{"_1.png"}, \code{"_2.pdf"},
\code{"_2.png"}, ... Existing files with the generated filenames are overwritten.
}
\seealso{
\code{\link{rnb.sample.groups}} for identifying traits in the annotation table that define sample subgroups;
         \code{\link{createReportPlot}} for the allowed symbols to be used in \code{fileprefix}
}
\author{
Yassen Assenov
}
