% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profiles.R
\name{rnb.plot.betadistribution.sampleGroups}
\alias{rnb.plot.betadistribution.sampleGroups}
\title{rnb.plot.betadistribution.sampleGroups}
\usage{
rnb.plot.betadistribution.sampleGroups(
  beta.matrix,
  sample.group.inds,
  annotation = "Group",
  log.str = NULL,
  points.per.group = rnb.getOption("distribution.subsample")
)
}
\arguments{
\item{beta.matrix}{Beta values in the form of a non-empty \code{matrix} of type \code{double}. Rows in this
matrix must correspond to Infinium probes, and columns - to samples.}

\item{sample.group.inds}{Named \code{list} that contains indices for the samples contained in the groups in
   \code{beta.matrix}. The number of groups is determined by the length of the list, and its
names are used as group names.}

\item{annotation}{Name of the annotation being visualized, in the form of a \code{character} vector of length 1.}

\item{log.str}{string specifying more details for the log file}

\item{points.per.group}{the targeted number of points per group. Set this to a value < 1 to disable subsampling. More
information in the Details section of \code{\link{rnb.step.betadistribution}}}
}
\value{
the plot as a \code{ggplot2} object
}
\description{
Plots beta value distrubions given a sample grouping.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
meth.mat <- meth(rnb.set.example)
sample.groups <- rnb.sample.groups(rnb.set.example)[[1]]
rnb.plot.betadistribution.sampleGroups(meth.mat,sample.groups)
}
}
\seealso{
rnb.plot.betadistribution.probeCategories
}
\author{
Fabian Mueller
}
