% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{rnb.execute.context.removal}
\alias{rnb.execute.context.removal}
\title{rnb.execute.context.removal}
\usage{
rnb.execute.context.removal(
  rnb.set,
  contexts = rnb.getOption("filtering.context.removal")
)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type \code{\linkS4class{RnBeadSet}}.}

\item{contexts}{Probe contexts to be filtered out.}
}
\value{
List of three or four elements:
        \describe{
          \item{\code{"dataset.before"}}{Copy of \code{rnb.set}.}
          \item{\code{"dataset"}}{The (possibly modified) \code{RnBeadSet} object after performing the missing
               value removal.}
          \item{\code{"filtered"}}{\code{integer} vector storing the indices of all removed probes in
               \code{dataset.before}.}
          \item{\code{"contexts"}}{The value of the parameter \code{contexts}.}
        }
}
\description{
Removes all probes that belong to specific context from the given dataset.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
contexts.to.ignore <- c("CC", "CAG", "CAH")
rnb.set.filtered <- rnb.execute.context.removal(rnb.set.example, contexts.to.ignore)$dataset
identical(rnb.set.example, rnb.set.filtered) # FALSE
}
}
\author{
Yassen Assenov
}
