% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{performGOenrichment.diffMeth.entrez}
\alias{performGOenrichment.diffMeth.entrez}
\title{performGOenrichment.diffMeth.entrez}
\usage{
performGOenrichment.diffMeth.entrez(
  gids,
  uids,
  ontology,
  assembly = "hg19",
  ...
)
}
\arguments{
\item{gids}{gene ids to test (entrez IDs)}

\item{uids}{ids to test against (universe)}

\item{ontology}{which ontology should be used (see \code{GOHyperGParams} from the \code{GOstats} package for details)}

\item{assembly}{Genome to be used. One of the following: hg19, mm9, mm10 or rn5}

\item{...}{arguments passed on to the parameters of \code{GOHyperGParams} from the \code{GOstats} package}
}
\value{
a \code{GOHyperGresult} object (see the \code{GOstats} package for further details)
}
\description{
performs Gene Ontology (GO) enrichment analysis for a list of Entrez identifiers
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
dm <- rnb.execute.computeDiffMeth(rnb.set.example,pheno.cols=c("Sample_Group","Treatment"))
dmt <- get.table(dm,get.comparisons(dm)[1],"promoters")
annot <- annotation(rnb.set.example,"promoters")
all.promoters <- annot$entrezID
#get the hypermethylated promoters
hyper.promoters <- annot$entrezID[dmt[,"mean.mean.diff"]>0]
result <- performGOenrichment.diffMeth.entrez(hyper.promoters,all.promoters,"BP",assembly="hg19")
}
}
\author{
Fabian Mueller
}
