% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{logger.start}
\alias{logger.start}
\alias{logger.completed}
\alias{logger.close}
\title{Log File Management}
\usage{
logger.start(txt = character(0), fname = NULL)

logger.completed()

logger.close()
}
\arguments{
\item{txt}{Description to add to the log file. The words \code{STARTED} and \code{COMPLETED} are prepended to the
message upon initialization and completion of the section, respectively.}

\item{fname}{Name of the log file and/or console. Note that at most one file name can be specified. The function
\code{logger.start} normalizes the given name, that is, it converts it to an absolute name. If this
parameter is \code{NA}, logger messages are printed to the console. If it is a two-element vector
containing one file name and \code{NA}, the logger is (re)initialized to print messages both to the
given file name and the console. A value of \code{NULL} (default) indicates the logger should continue
using the previously specified file.}
}
\value{
None (invisible \code{NULL}).
}
\description{
Functions for logger management.
}
\section{Details}{

\code{logger.start} initializes the logger and/or starts a new section. \code{logger.completed} completes the last
(innermost) open section in the log. \code{logger.close} deinitializes the logger. Note that after reinitialization
or deinitialization, the information about the current output file, as well as any open sections, is deleted.
}

\examples{
\donttest{
if (!logger.isinitialized())
  logger.start(fname = NA)
logger.start("Tests for Significance")
logger.completed()
logger.close()
}
}
\seealso{
logger.isinitialized
}
\author{
Yassen Assenov
}
