% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterArchitectureSGE.R
\docType{methods}
\name{getSubCmdTokens,ClusterArchitectureSGE-method}
\alias{getSubCmdTokens,ClusterArchitectureSGE-method}
\title{getSubCmdTokens-methods}
\usage{
\S4method{getSubCmdTokens}{ClusterArchitectureSGE}(
  object,
  cmd.tokens,
  log,
  job.name = "",
  res.req = character(0),
  depend.jobs = character(0),
  sub.binary = TRUE,
  quote.cmd = TRUE,
  queue = NULL
)
}
\arguments{
\item{object}{\code{\linkS4class{ClusterArchitectureSGE}} object}

\item{cmd.tokens}{a character vector specifying the executable command that should be wrapped in the cluster submission command}

\item{log}{file name and path of the log file that the submitted job writes to}

\item{job.name}{name of the submitted job}

\item{res.req}{character vector specifying required resources. The resource requirements should be the values of the vector,
the names should specify the resource name}

\item{depend.jobs}{character vector containg names or ids of jobs the submitted job will depend on.}

\item{sub.binary}{treat the command as binary (see \code{-b} flag of \code{qsub} of the SGE documentation)}

\item{quote.cmd}{Flag indicating whether the submitted cammed should also be wrapped in quotes}

\item{queue}{The name of the queue to submit jobs to}
}
\value{
A character vector containing the submission command tokens
}
\description{
Returns a string for the of command line corresponding to submitting
a job with the given command to the cluster.
}
\details{
For a concrete child class implementation for a sun grid architecture specification see \code{\linkS4class{ClusterArchitectureSGE}}
}
\examples{
\donttest{
arch <- new("ClusterArchitectureSGE",
	name="my_sge_architecture"
)
getSubCmdTokens(arch,c("Rscript","my_great_script.R"),"my_logfile.log")
}
}
\author{
Fabian Mueller
}
