% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lolaUtils.R
\name{getCellTypesFromLolaDb}
\alias{getCellTypesFromLolaDb}
\title{getCellTypesFromLolaDb}
\usage{
getCellTypesFromLolaDb(lolaDb)
}
\arguments{
\item{lolaDb}{LOLA DB object as returned by \code{LOLA::loadRegionDB} or \code{\link{loadLolaDbs}}}
}
\value{
character vector with cell types
}
\description{
retrieve or guess cell types from a LOLA DB object
}
\examples{
\donttest{
# download LOLA DB
lolaDest <- tempfile()
dir.create(lolaDest)
lolaDirs <- downloadLolaDbs(lolaDest, dbs="LOLACore")
lolaDb <- loadLolaDbs(lolaDirs[["hg19"]])
getCellTypesFromLolaDb(lolaDb)
}
}
\author{
Fabian Mueller
}
