% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialVariability.R
\name{diffVar}
\alias{diffVar}
\title{diffVar}
\usage{
diffVar(meth.matrix, inds.g1, inds.g2, adjustment.table = NULL, paired = FALSE)
}
\arguments{
\item{meth.matrix}{Matrix containing the methylation information used to calculate differentially variable sites 
between the two groups}

\item{inds.g1}{Indices in the phenotypic table corresponding to the first group.}

\item{inds.g2}{Indices in the phenotypic table corresponding to the second group.}

\item{adjustment.table}{A \code{data.frame} containing variables to adjust for in the testing}

\item{paired}{Should the analysis be performed in a paired fashion. If yes, the first index in \code{inds.g1} must 
correspond to the first in \code{inds.g2} and so on.}
}
\value{
P-values as the result of the diffVar method not adjusted for multiple hypothesis testing.
}
\description{
This routine applies the diffVar method from the \code{missMethyl} package that determines sites exhibiting
differential variability between two sample groups
}
\references{
Phipson, Belinda, Oshlack, Alicia (2014)
            DiffVar: a new method for detecting differential variability with application to methylation in cancer and aging
            Genome Biology 15(9):465.
}
\author{
Michael Scherer
}
