% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingUtils.R
\name{create.densityScatter}
\alias{create.densityScatter}
\title{create.densityScatter}
\usage{
create.densityScatter(
  df2p,
  is.special = NULL,
  dens.subsample = FALSE,
  dens.special = TRUE,
  sparse.points = 0.01,
  dens.n = 100,
  add.text.cor = FALSE
)
}
\arguments{
\item{df2p}{\code{data.frame} to be plotted. Only the fist two columns are taken into account as
x and y coordinates respectively}

\item{is.special}{boolean vector of length equal to the number of rows in \code{df2p}. Specifies
which points should be highlighed seperately in a different color}

\item{dens.subsample}{if the number of points exceeds this number, subsample the number of points for the
density estimation to that number. Any non-numeric value disables subsampling.}

\item{dens.special}{Flag indicating whether the points of the special population should be colored
according to their density}

\item{sparse.points}{Either percentage (\code{<=1,>=0}) or the absolute number 
 of points in the sparsely populated area that should be drawn seperately. A value of 0 means that these points
will not be drawn.}

\item{dens.n}{passed on to \code{ggplot2::stat_density2d}: argument: \code{n}}

\item{add.text.cor}{flag indicating whether a text token with the correlation coefficient should be included in the lower
right corner of the plot}
}
\value{
\code{ggplot} object
}
\description{
Creates a density scatterplot highlighting points in sparsely populated plot regions
as well as points marked as special in a seperate color
}
\examples{
\donttest{
d <- data.frame(x=rnorm(1000),y=rnorm(1000))
s <- rep(FALSE,1000)
s[sample(1:length(s),100)] <- TRUE
create.densityScatter(d,s)
}
}
\author{
Fabian Mueller
}
