% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialMethylation.R
\name{computeDiffTab.default.site}
\alias{computeDiffTab.default.site}
\alias{computeDiffTab.site}
\alias{computeDiffTab.extended.site}
\title{computeDiffTab.site}
\usage{
computeDiffTab.default.site(
  X,
  inds.g1,
  inds.g2,
  diff.method = rnb.getOption("differential.site.test.method"),
  variability.method = rnb.getOption("differential.variability.method"),
  paired = FALSE,
  adjustment.table = NULL,
  eps = 0.01,
  imputed = FALSE
)

computeDiffTab.extended.site(
  X,
  inds.g1,
  inds.g2,
  diff.method = rnb.getOption("differential.site.test.method"),
  variability.method = rnb.getOption("differential.variability.method"),
  paired = FALSE,
  adjustment.table = NULL,
  eps = 0.01,
  covg = NULL,
  covg.thres = rnb.getOption("filtering.coverage.threshold"),
  imputed = FALSE
)
}
\arguments{
\item{X}{Matrix on which the difference measures are calculated for every row}

\item{inds.g1}{column indices of group 1 members}

\item{inds.g2}{column indices of group 2 members}

\item{diff.method}{Method to determine p-values for differential methylation. Currently supported are 
    "ttest" for a two-sided Welch t-test, "refFreeEWAS" for adjusting for cell mixtures,
    and "limma" for p-values resulting from linear modeling of the transformed beta values (M-values)
and using techniques from expression microarray analysis employed in the \code{limma} package.}

\item{variability.method}{Method to determine p-values for differential variability. Currently supported are 
"diffVar" for the diffVar method implemented in the missMethyl bioconductor package,
and "iEVORA".}

\item{paired}{should a paired a analysis be performed. If \code{TRUE} then inds.g1 and inds.g2 should have exactly the same length and should be
order, such that the first element of inds.g1 corresponds to the first element of inds.g2 and so on.}

\item{adjustment.table}{a table of variables to be adjusted for in the differential methylation test. Currently this is only supported for
\code{diff.method=="limma"}}

\item{eps}{Epsilon for computing quotients (avoid division by 0 by adding this value to denominator and enumerator before calculating the quotient)}

\item{imputed}{flag indicating if methylation matrix was already imputed}

\item{covg}{coverage information (should be NULL for disabled or of equal dimensions as X)}

\item{covg.thres}{a coverage threshold}
}
\value{
a dataframe containing the following variables:
\item{mean.g1}{Mean of group 1}
\item{mean.g2}{Mean of group 2}
\item{mean.diff}{Difference in means}
\item{mean.quot.log2}{log2 of the quotient of means}
\item{diffmeth.p.val}{P-value (as determined by \code{diff.method})}
\item{max.g1/max.g2}{[extended version only] Group maxima}
\item{min.g1/min.g2}{[extended version only] Group minima}
\item{sd.g1/sd.g2}{[extended version only] Group standard deviations}
\item{min.diff}{[extended version only] Minimum of 0 and single linkage difference between the groups}
\item{diffmeth.p.adj.fdr}{[extended version only] FDR adjusted p-values}
\item{num.na.g1/num.na.g2}{[extended version only] number of NA methylation values for groups 1 and 2 respectively}
\item{mean.covg.g1/mean.covg.g2}{[extended version with coverage information only] mean coverage of groups 1 and 2 respectively}
\item{min.covg.g1/min.covg.g2}{[extended version with coverage information only] minimum coverage of groups 1 and 2 respectively}
\item{max.covg.g1/max.covg.g2}{[extended version with coverage information only] maximum coverage of groups 1 and 2 respectively}
\item{covg.thresh.nsamples.g1/2}{[extended version with coverage information only] number of samples in group 1 and 2 respectively exceeding the
									coverage threshold for this site.}
}
\description{
computes a difference table containing multiple difference measures,
In the simple version the difference in means,
quotients in means and a p-value for the comparison of two groups in a table are computed.
This is computed for each row of the input table. The extended version contains additional columns
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
meth.mat <- meth(rnb.set.example)
sample.groups <- rnb.sample.groups(rnb.set.example)[[1]]
dm <- computeDiffTab.extended.site(meth.mat,sample.groups[[1]],sample.groups[[2]])
summary(dm)
}
}
\author{
Fabian Mueller
}
