% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiftedZScoreTx.R
\name{shiftedZScoreTx}
\alias{shiftedZScoreTx}
\title{Calculate shifted z scores}
\usage{
shiftedZScoreTx(permTestTx_results = NULL, txdb = NULL,
window = 200, step = 20, ev_function_1 = overlapCountsTx, ...)
}
\arguments{
\item{permTestTx_results}{A \code{permTestTx.results} object.}

\item{txdb}{A TxDb object.}

\item{window}{The window of the whole shifting.}

\item{step}{The step of each shifting.}

\item{ev_function_1}{Evaluation function. Default is \code{overlapCountsTx}.}

\item{...}{Any additional parameters needed.}
}
\value{
A list object, which is defined to be \code{shitedZScore.results} class. It contains the following items:
\itemize{
\item \bold{\code{shifted.z.scores:}} Standard z-scores after shifting.
\item \bold{\code{window:}} Window of the whole shifting.
\item \bold{\code{step:}} Step of each shifting.
\item \bold{\code{original.z.score:}} Original standard score.
}
}
\description{
Calculate shifted z scores for permutation test results.
}
\details{
see examples in \code{\link{plotShiftedZScoreTx}}
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
file <- system.file(package="RgnTX", "extdata/m6A_sites_data.rds")
m6A_sites_data <- readRDS(file)
RS1 <- m6A_sites_data[1:500]
permTestTx_results <- permTestTxIA_customPick(RS1 = RS1,
                                        txdb = txdb,
                                        customPick_function = getStopCodon,
                                        ntimes = 5)
shiftedZScoreTx_results <- shiftedZScoreTx(permTestTx_results, txdb = txdb,
                                        window = 2000,
                                        step = 200,
                                        ev_function_1 = overlapCountsTxIA)
}
\seealso{
\code{\link{plotShiftedZScoreTx}}
}
