% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiftTx.R
\name{shiftTx}
\alias{shiftTx}
\title{Shift over transcripts}
\usage{
shiftTx(regions, start, width, direction, strand)
}
\arguments{
\item{regions}{A feature set following the format indicated in vignette section 3. Either to be \code{GRanges} or \code{GRangesList}.}

\item{start}{Starting positions. Each value represents a starting position in each input feature.}

\item{width}{Widths. Each value represents a width of each region to be picked from each feature.}

\item{direction}{Either to be character "left" or "right", which means the direction to which the starting position is shifting. The former means moving to the direction of 5' while the latter means moving to 3'.}

\item{strand}{The strand type of the transcripts. It receives "+" or "-".}
}
\value{
A \code{Granges} object.
}
\description{
Calculate positional shifting over transcript regions. This function accepts a feature set and outputs a region set from it. Each output region is from each input feature.
}
\examples{
# Take five transcripts.
# Extract the last 200 nt regions from their CDS part.
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
trans.id.pstv <- c("170", "782", "974", "1364", "1387")
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene

# download the CDS part of all transcriptome
cds.tx0 <- cdsBy(txdb, use.names = FALSE)

# pick the CDS part of these five transcripts
cds.p <- cds.tx0[trans.id.pstv]

width <- 200
start <- as.numeric(max(end(cds.p)))
R.cds.last200 <- shiftTx(cds.p, start = start, width = width, direction = 'left', strand = "+")
}
