% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomizeFeaturesTx.R
\name{randomizeFeaturesTx}
\alias{randomizeFeaturesTx}
\title{Randomize features into transcriptome}
\usage{
randomizeFeaturesTx(RS, txdb, type = "mature", N = 1, ...)
}
\arguments{
\item{RS}{The feature to be randomized. It should be a \code{GRanges} or \code{GRangesList} object.}

\item{txdb}{A TxDb object.}

\item{type}{A character object. Default is "mature". It accepts options "mature", "full", "fiveUTR", "CDS" or "threeUTR", with which one can get corresponding types of transcriptome regions.}

\item{N}{The number of iterations.}

\item{...}{Any additional parameters needed.}
}
\value{
A \code{GRangesList} object. The name of each element is the id of the transcript where the corresponding range is located.
}
\description{
Randomize features into transcriptome.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
trans.ids <- c("170", "782", "974", "1364", "1387")
RS1 <- randomizeTx(txdb, trans.ids, random_num = 100, random_length = 100)
RS <- randomizeFeaturesTx(RS1, txdb, N = 1)
}
\seealso{
\code{\link{randomizeTransByOrder}}, \code{\link{randomizeFeaturesTxIA}}, \code{\link{randomizeTx}}
}
