% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRangesList2GRanges.R
\name{GRangesList2GRanges}
\alias{GRangesList2GRanges}
\title{Convert a GRangesList object to a GRanges object}
\usage{
GRangesList2GRanges(A = NULL)
}
\arguments{
\item{A}{A \code{GRangesList} object.}
}
\value{
A \code{GRanges} object. Its transcript ids (if available) should be contained in a metadata column named “transcriptsHits”, which are provided by the names of input \code{GRangesList} object.
}
\description{
Convert a \code{GRangesList} object to a \code{GRanges} object. The output region set follows the format required by the RgnTX permutation test functions, which should have metadata columns 'group' and 'transcriptsHits'.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
trans.ids <- c("170", "782", "974", "1364", "1387")
RS1 <- randomizeTx(txdb, trans.ids, random_num = 100, random_length = 100)

RS1 <- GRangesList2GRanges(RS1)
}
\seealso{
\code{\link{GRanges2GRangesList}}
}
