% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ReducedExperiment.R
\name{reduced}
\alias{reduced}
\alias{reduced<-}
\alias{reduced,ReducedExperiment-method}
\alias{reduced<-,ReducedExperiment-method}
\title{Get and set reduced data}
\usage{
\S4method{reduced}{ReducedExperiment}(object, scale_reduced = FALSE, center_reduced = FALSE)

\S4method{reduced}{ReducedExperiment}(object) <- value
}
\arguments{
\item{object}{An object that inherits from
\link[ReducedExperiment]{ReducedExperiment}.}

\item{scale_reduced}{If \code{TRUE}, data will be scaled column-wise to have a
standard deviation of 0.}

\item{center_reduced}{If \code{TRUE}, data will be centered column-wise to have a
mean of 0.}

\item{value}{New value to replace existing reduced data matrix.}
}
\value{
A matrix with samples/observations as rows and columns referring
to the dimensionally-reduced components.
}
\description{
Retrieves the reduced data matrix, with samples as rows and reduced
components as columns. Setter method can be used to replace or modify
all or part of the matrix.
}
\examples{
# Create randomised data with the following dimensions
i <- 300 # Number of features
j <- 100 # Number of samples
k <- 10 # Number of factors

rand_assay_data <- ReducedExperiment:::.makeRandomData(i, j, "gene", "sample")
rand_reduced_data <- ReducedExperiment:::.makeRandomData(j, k, "sample", "component")

re <- ReducedExperiment(
    assays = list("normal" = rand_assay_data),
    reduced = rand_reduced_data
)

stopifnot(all.equal(reduced(re), rand_reduced_data))

print(paste0("Reduced data at position (2, 2): ", reduced(re)[2, 2]))
reduced(re)[2, 2] <- 5
print(paste0("Reduced data at position (2, 2): ", reduced(re)[2, 2]))

}
\seealso{
\code{\link[=ReducedExperiment]{ReducedExperiment()}}
}
\author{
Jack Gisby
}
