% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ModularExperiment.R
\name{calcEigengenes}
\alias{calcEigengenes}
\alias{calcEigengenes,ModularExperiment,matrix-method}
\alias{calcEigengenes,ModularExperiment,data.frame-method}
\alias{calcEigengenes,ModularExperiment,SummarizedExperiment-method}
\alias{predict,ModularExperiment-method}
\title{Calculate eigengenes for new data}
\usage{
\S4method{calcEigengenes}{ModularExperiment,matrix}(
  object,
  newdata,
  project = FALSE,
  scale_reduced = TRUE,
  return_loadings = FALSE,
  scale_newdata = NULL,
  center_newdata = NULL,
  realign = TRUE,
  min_module_genes = 10
)

\S4method{calcEigengenes}{ModularExperiment,data.frame}(
  object,
  newdata,
  project = FALSE,
  scale_reduced = TRUE,
  return_loadings = FALSE,
  scale_newdata = NULL,
  center_newdata = NULL,
  realign = TRUE,
  min_module_genes = 10
)

\S4method{calcEigengenes}{ModularExperiment,SummarizedExperiment}(
  object,
  newdata,
  project = FALSE,
  scale_reduced = TRUE,
  assay_name = "normal",
  scale_newdata = NULL,
  center_newdata = NULL,
  realign = TRUE,
  min_module_genes = 10
)

\S4method{predict}{ModularExperiment}(object, newdata, ...)
}
\arguments{
\item{object}{A \link[ReducedExperiment]{ModularExperiment} object. By
default, the \code{scale} and \code{center} slots are used to apply the original
transformation to the new data. The
\code{loadings} slot of this class will be used if \code{project} is \code{TRUE}.}

\item{newdata}{New data for eigengenes to be calculated in. Must be a
\code{data.frame} or \code{matrix} with features as rows and samples as columns, or a
\link[SummarizedExperiment]{SummarizedExperiment} object. Assumes that the
rows of \code{newdata} match those of the
\link[ReducedExperiment]{ModularExperiment} object.}

\item{project}{If \code{FALSE} (default), calculate
eigengenes from
scratch in the new dataset using an approach similar to
\link[WGCNA]{moduleEigengenes} (i.e., performing PCA for each module in
\code{newdata}). If \code{FALSE}, perform projection, using PCA rotation matrix
from the original data to calculate module eigengenes. Projection approach
is experimental.}

\item{scale_reduced}{Whether or not the reduced data should be scaled
after calculation.}

\item{return_loadings}{If \code{TRUE}, additionally returns the feature loadings for
the eigengenes.}

\item{scale_newdata}{Controls whether the \code{newdata} are scaled. If \code{NULL},
performs scaling based on the \link[ReducedExperiment]{ModularExperiment}
object's \code{scale} slot. The value of this argument will be passed to the
\code{scale} argument of \link[base]{scale}.}

\item{center_newdata}{Controls whether the \code{newdata} are centered If \code{NULL},
performs centering based on the \link[ReducedExperiment]{ModularExperiment}
object's \code{center} slot. The value of this argument will be passed to the
\code{center} argument of \link[base]{scale}.}

\item{realign}{If \code{project} is \code{TRUE}, this argument is ignored. Else, controls
whether eigengenes are realigned after PCA is performed to ensure the
resultant signatures are positively correlated with average expression of the
module. Similar to the \code{align} argument of \link[WGCNA]{moduleEigengenes}.}

\item{min_module_genes}{If \code{project} is \code{FALSE}, this argument is ignores.
Else, controls the minimum number of genes required in a module for
projection. Projected eigengenes are not calculated for modules with sizes
below this threshold.}

\item{assay_name}{If a \link[SummarizedExperiment]{SummarizedExperiment}
object is passed as new data, this argument indicates which assay should be
used for projection.}

\item{...}{Additional arguments to be passed to
\link[ReducedExperiment]{calcEigengenes}.}
}
\value{
If return_loadings is \code{TRUE}, returns a list with the "reduced" matrix
and "loadings" vector (one value per feature). If \code{FALSE}, returns only the
reduced matrix.

The reduced matrix has samples as rows and modules as columns. If
\code{newdata} was a \code{matrix} or \code{data.frame}, this will be returned as a matrix.
If a \link[SummarizedExperiment]{SummarizedExperiment} object was passed
instead, then a If a \link[ReducedExperiment]{ModularExperiment}
object will be created containing this matrix in its \code{reduced} slot.
}
\description{
Calculates eigengenes for modules in new data. By default, eigengenes are
calculated from scratch using PCA, in a similar manner to the
\link[WGCNA]{moduleEigengenes} function. The function also offers a
projection approach, which functions in a similar fashion to the
\code{predict} method of \link[stats]{prcomp}.
}
\details{
If \code{scale_newdata} and \code{center_newdata} are left as \code{NULL}, then the
projection method assumes that the \code{newdata} are on the same scale as the
original data of the \code{object}. It will therefore use the values of the
\code{center} and \code{scale} slots of the \code{object}. For instance, if the \code{scale} slot
is \code{TRUE}, the \code{newdata} will be scaled. If the \code{scale} slot is a vector,
the values of this vector will be applied to scale the \code{newdata}.
}
\examples{
# Create ModularExperiment with random data (100 features, 50 samples,
# 10 modules)
me_1 <- ReducedExperiment:::.createRandomisedModularExperiment(100, 50, 10)

# Generate a new dataset with the same features (100 rows) but different
# samples/observations (20 columns)
X_2 <- ReducedExperiment:::.makeRandomData(100, 20, "gene", "sample")

# We can use the projection approach to calculate the eigengenes for
# the modules identified in dataset 1 for the samples in dataset 2
# This approach is based on the module loadings
me_2_project <- calcEigengenes(me_1, X_2, project = TRUE)
me_2_project[1:5, 1:5]

# Alternatively, we can calculate eigengenes from scratch in the second
# dataset. This still uses the modules identified in the first dataset (me_1)
# but does not make use of the loadings. This approach is similar to
# that applied by WGCNA::moduleEigengenes.
me_2_eig <- calcEigengenes(me_1, X_2, project = FALSE)
me_2_eig[1:5, 1:5]

}
\seealso{
\code{\link[ReducedExperiment]{projectData}},
\code{\link[WGCNA]{moduleEigengenes}}
}
\author{
Jack Gisby
}
