% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_heatmap,ReactomeAnalysisResult-method}
\alias{plot_heatmap,ReactomeAnalysisResult-method}
\title{plot_heatmap - ReactomeAnalysisResult}
\usage{
\S4method{plot_heatmap}{ReactomeAnalysisResult}(
  x,
  fdr = 0.01,
  max_pathways = 30,
  break_long_names = TRUE,
  return_data = FALSE
)
}
\arguments{
\item{x}{ReactomeAnalysisResult. The result object to use as input}

\item{fdr}{numeric. The minimum FDR to consider a pathways as significantly
regulated. (Default 0.01)}

\item{max_pathways}{numeric. The maximum number of pathways to plot. Pathways
are sorted based on in how many datasets they are significantly regulated.
This has no effect if \code{return_data} is set to \code{TRUE}.}

\item{break_long_names}{logical. If set, long pathway names are broken into
two lines.}

\item{return_data}{logical. If set, only the plotting data, but not the plot
object itself is returned. This can be used to create customized plots
that use the same data structure.}
}
\value{
A ggplot2 plot object representing the heatmap of pathways
}
\description{
Creates a heatmap to show which pathways are up- and down-regulated
in different datasets
}
\examples{
# load an example result
library(ReactomeGSA.data)
data(griss_melanoma_result)

# create the heatmap plot
plot_obj <- plot_heatmap(griss_melanoma_result)

# show the plot
print(plot_obj)
}
\seealso{
Other ReactomeAnalysisResult functions: 
\code{\link{get_result}()},
\code{\link{names,ReactomeAnalysisResult-method}},
\code{\link{open_reactome}()},
\code{\link{pathways}()},
\code{\link{plot_correlations}()},
\code{\link{plot_gsva_heatmap}()},
\code{\link{plot_gsva_pathway}()},
\code{\link{plot_volcano}()},
\code{\link{reactome_links}()},
\code{\link{result_types}()}
}
