% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_correlations}
\alias{plot_correlations}
\title{plot_correlations}
\usage{
plot_correlations(x, hide_non_sig = FALSE)
}
\arguments{
\item{x}{ReactomeAnalysisResult. The result object to use as input}

\item{hide_non_sig}{If set, non-significant pathways are not shown.}
}
\value{
A list of ggplot2 plot objects representing one plot per combination
}
\description{
Plots correlations of the average fold-changes of all pathways between
the different datasets. This function is only available to GSA based
results (not GSVA ones).
}
\examples{
# load an example result
library(ReactomeGSA.data)
data(griss_melanoma_result)

# create the correlation plots
plot_objs <- plot_correlations(griss_melanoma_result)

# only one plot created for this result as it contains two datasets
length(plot_objs)

# show the plot using `print(plot_objs[[1]])`
}
\seealso{
Other ReactomeAnalysisResult functions: 
\code{\link{get_result}()},
\code{\link{names,ReactomeAnalysisResult-method}},
\code{\link{open_reactome}()},
\code{\link{pathways}()},
\code{\link{plot_gsva_heatmap}()},
\code{\link{plot_gsva_pathway}()},
\code{\link{plot_heatmap}()},
\code{\link{plot_volcano}()},
\code{\link{reactome_links}()},
\code{\link{result_types}()}
}
\concept{ReactomeAnalysisResult functions}
