% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_result.R
\name{get_result}
\alias{get_result}
\title{get_result}
\usage{
get_result(x, type, name)
}
\arguments{
\item{x}{ReactomeAnalysisResult.}

\item{type}{the type of result. Use \code{\link{result_types}}
to retrieve all available types.}

\item{name}{the name of the result. Use \code{\link{names}}
to retrieve all available results.}
}
\value{
A \code{data.frame} containing the respective result.
}
\description{
Retrieves a result from a \code{\link{ReactomeAnalysisResult}} object.
}
\examples{
# load an example result object
library(ReactomeGSA.data)
data(griss_melanoma_result)

# get the available result types
result_types(griss_melanoma_result)

# get the dataset names
names(griss_melanoma_result)

# get the fold_changes for the first dataset
prot_fc <- get_result(griss_melanoma_result, type = "fold_changes", name = "proteomics")

head(prot_fc)
}
\seealso{
Other ReactomeAnalysisResult functions: 
\code{\link{names,ReactomeAnalysisResult-method}},
\code{\link{open_reactome}()},
\code{\link{pathways}()},
\code{\link{plot_correlations}()},
\code{\link{plot_gsva_heatmap}()},
\code{\link{plot_gsva_pathway}()},
\code{\link{plot_heatmap}()},
\code{\link{plot_volcano}()},
\code{\link{reactome_links}()},
\code{\link{result_types}()}
}
\concept{ReactomeAnalysisResult functions}
