#ifndef IMS_TANDEMFRAGMENTER_H
#define IMS_TANDEMFRAGMENTER_H

#include <algorithm>

#include <ims/fragmenter.h>

namespace ims {
// TODO: adapt to new fragmenter base class
#if 0
/**
 * An implementation of the Fragmenter interface to compute the tandem
 * MS peaklist of a sequence, that is the prefix and suffix weights.
 * This fragmenter only computes the unaltered, raw sum of character
 * weights for each prefix/suffix. To get a real simulated spectrum,
 * an according Modifier class has to be added to compute the
 * A/B/C/X/Y/Z ion series peaks of the raw peaks.
 */
template <typename AlphabetType, typename PeakListType, typename MassType=typename AlphabetType::ScaledValueType >
class TandemFragmenter : public Fragmenter<PeakListType, MassType> {
    public:
		/**
		 * Construct tandem MS fragmenter.
		 * @param alphabet A weighted alphabet for character weights
		 * @param mod A modifier class to modify the predicted spectrum before returning it.
		 **/
		TandemFragmenter(AlphabetType alphabet, Modifier<PeakListType>* mod=0): alphabet(alphabet){
			setModifier(mod);
		};

		virtual void predictSpectrum(PeakListType& fragmentList, const std::string& seq);
		virtual void predictSpectrum(PeakListType& fragmentList, const IDSequence<std::string> seq);
		virtual ~TandemFragmenter() {};

	protected:
		using Fragmenter<PeakListType, MassType>::mod;
		AlphabetType alphabet;
};


/**
 * Computes masses of the predicted spectrum generated by a sequence.
 * Computes fragment list of given sequence using the given cleavage scheme. Then computes unique mass list
 * of fragment list using weighted alphabet. Each mass is returned only once and all masses are ordered.
 * @param fragmentList A vector in which the unique fragment-masses are stored in ascending order
 * @param seq The sequence for which the spectrum-masses are computed
 */
template <typename AlphabetType, typename PeakListType, typename MassType>
void TandemFragmenter<AlphabetType,PeakListType,MassType>::predictSpectrum(PeakListType& fragmentList, std::string seq) {
	MassType currentMass=0;

	// delete current content of return vector
	fragmentList.clear();
	if(seq.length()>0) {
		std::string::const_iterator it;
		// iterate over sequence
		// compute prefix masses, store parent mass
		for(it=seq.begin();it!=seq.end();it++) {
			currentMass += alphabet.getMass(std::string(1,*it));
			fragmentList.push_back(PeakType(currentMass, 1.0));
		}
		// compute suffix masses from parent and prefixes
		size_t listSize = fragmentList.size();
		for(size_t i=0;i<listSize;i++) {
			fragmentList.push_back(PeakType(currentMass-fragmentList[i].getMass(), 1.0));
		}

		if(mod!=0) {
			mod->modify(fragmentList);
		}
	}
}

/**
 * Computes masses of the predicted spectrum generated by a sequence.
 * Computes fragment list of given sequence using the given cleavage scheme. Then computes unique mass list
 * of fragment list using weighted alphabet. Each mass is returned only once and all masses are ordered.
 * @param fragmentList A vector in which the unique fragment-masses are stored in ascending order
 * @param seq The IDSequence for which the spectrum-masses are computed, ID will be copied to PeakList
 */
template <typename AlphabetType, typename PeakListType, typename MassType>
void TandemFragmenter<AlphabetType,PeakListType,MassType>::predictSpectrum(PeakListType& fragmentList, IDSequence<std::string> seq) {
    // copy ID
    fragmentList.setID(seq.getID());
    // compute peaklist
    this->predictSpectrum(fragmentList, seq.getSequence());
}
#endif

}
#endif
