% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomposeIsotopes.R
\name{decomposeIsotopes}
\alias{decomposeIsotopes}
\alias{decomposeMass}
\alias{isotopeScore}
\title{Mass Decomposition of Isotope Patterns}
\usage{
decomposeIsotopes(
  masses,
  intensities,
  ppm = 2,
  mzabs = 1e-04,
  elements = NULL,
  filter = NULL,
  z = 0,
  maxisotopes = 10,
  minElements = "C0",
  maxElements = "C999999"
)

decomposeMass(
  mass,
  ppm = 2,
  mzabs = 1e-04,
  elements = NULL,
  filter = NULL,
  z = 0,
  maxisotopes = 10,
  minElements = "C0",
  maxElements = "C999999"
)

isotopeScore(molecule, masses, intensities)
}
\arguments{
\item{masses}{A vector of masses (or m/z values) of an isotope cluster.}

\item{intensities}{Absolute or relative intensities of the \code{masses} peaks.}

\item{ppm}{Allowed deviation of hypotheses from given mass.}

\item{mzabs}{Absolute deviation in Dalton (mzabs and ppm will be added).}

\item{elements}{List of allowed chemical elements, defaults to CHNOPS. 
See \code{\link{initializeElements}}. Can also be specified similar to
parameter `minElements` like a formula. 'CHNOPS' would define the elements
C, H, N, O, P and S. 'NA' would specify the element N and return a warning
regarding 'A' because this element is undefined in the PSE.}

\item{filter}{NYI, will be a selection of DU, DBE and Nitrogen rules.}

\item{z}{Charge z of m/z peaks for calculation of real mass, keep z=0 for auto-detection.}

\item{maxisotopes}{Maximum number of isotopes shown in the resulting molecules.}

\item{minElements}{Molecular formula, defining lower boundaries of allowed elements.}

\item{maxElements}{Molecular formula, defining upper boundaries of allowed elements.}

\item{mass}{A single mass (or m/z value).}

\item{molecule}{An initialized molecule as returned by getMolecule() or the decomposeMass() and decomposeIsotopes() functions.}
}
\value{
A list of molecules, which contain the sub-lists `formulas` potential 
    formulas, `exactmass` exact mass of each hypothesis (not monoisotopic), 
    `score` calculated score, `isotopes` a list of isotopes.
}
\description{
Calculate the elementary compositions from an exact mass or
    isotope pattern, obtained e.g. by FTICR or TOF mass spectrometers.
}
\details{
Sum formulas are calculated which explain the given mass or isotope pattern.
}
\examples{
# query some measurement values from a Glutamate peak which will return two
# suggested/potential sum formulas
m <- c(147.0529, 148.0563, 149.0612)
i <- c(0.91, 0.06, 0.01)
mol <- decomposeIsotopes(m, i, maxisotopes = 3)
getFormula(mol)

# Rdisop returns the scores (how well does the exact data match the measured 
# data) in a normalized fashion, but you can calculate the raw scores
getScore(mol)
isotopeScore(mol, m, i)

# using a 5 mDa window, the number of potential candidates is increased to 26
getFormula(decomposeIsotopes(m, i, mzabs = 0.005))

# elemental ranges can be specified to affect the result
# use maxElements to exclude all of the above suggestions containing more 
# than one S and/or one P.
getFormula(decomposeIsotopes(m, i, mzabs = 0.005, maxElements = "S1P1"))


}
\references{
For a description of the underlying IMS see citation("Rdisop")
}
\author{
Steffen Neumann <sneumann@IPB-Halle.DE>
}
