% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwlLoad.R
\name{cwlLoad}
\alias{cwlLoad}
\title{cwlLoad}
\usage{
cwlLoad(
  rname,
  bfc = NULL,
  env = .GlobalEnv,
  cwlfile = NULL,
  dir = tempdir(),
  ...
)
}
\arguments{
\item{rname}{The name or filepath of tool or pipeline to install
(`rname` or `fpath` column from the `bfc` object returned from
`cwlSearch`). It can also be a CWL url or a github repo.}

\item{bfc}{The `BiocFileCache` object for the recipes. The default
is NULL which automatically detect the "Rcwl" cache directory.}

\item{env}{The R enviroment to export to. The default is
`.GlobalEnv`.}

\item{cwlfile}{For github repo input, The relative path of a CWL
file inside of the github repo.}

\item{dir}{For github repo input, the directory to clone the repo.}

\item{...}{More options from git2r::clone.}
}
\value{
A `cwlProcess` object. For pipelines, the dependent tools
    will also loaded.
}
\description{
To source Rcwl scripts
}
\details{
Note to developers that the dependent Rcwl scripts should
    be included in the recipe with `@include` tag.
}
\examples{
\dontrun{
tls <- cwlSearch("bwa")
title(tls)
bwa <- cwlLoad("tl_bwa")
bwa <- cwlLoad(tls$fpath[tls$rname == "tl_bwa"])  ## equivalent
bwa
}
}
