test_that("boolean zarr array can be read correctly", {
  zarr_c <- system.file(
    "extdata",
    "zarr_examples",
    "column-first",
    "boolean.zarr",
    package = "Rarr"
  )
  index <- list(1:5, NULL)

  # Shouldn't be any warnings for this input
  expect_silent(column_major <- read_zarr_array(zarr_c, index = index))

  # we return an array
  expect_true(is.array(column_major))

  # dimensions equal to the index
  expect_identical(dim(column_major), c(5L, 10L))

  # first row should be TRUE
  # second row should be FALSE
  expect_true(all(column_major[1, ]))
  expect_false(any(column_major[2, ]))
})
