% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RadioSet-class.R
\docType{class}
\name{RadioSet-class}
\alias{RadioSet-class}
\alias{.RadioSet}
\title{A Class to Contain RadioGenomic datasets together with their curations}
\value{
An object of the RadioSet class
}
\description{
The RadioSet (RSet) class was developed to contain and organise large
RadioGenomic datasets, and aid in their metanalysis. It was designed
primarily to allow bioinformaticians and biologists to work with data at the
level of genes and cell lines, providing a more naturally intuitive
interface and simplifying analyses between several datasets. As such, it was
designed to be flexible enough to hold datasets of two different natures
while providing a common interface. The class can accomidate datasets
containing both radiation dose response data, as well as datasets contaning
genetic profiles of cell lines pre and post treatement with compounds, known
respecitively as sensitivity and perturbation datasets.
}
\section{Slots}{

\describe{
\item{\code{annotation}}{A \code{list} of annotation data about the RadioSet,
including the \code{$name} and the session information for how the object
was creating, detailing the exact versions of R and all the packages used}

\item{\code{molecularProfiles}}{A \code{list} containing 4 \code{SummarizedExperiment}
type object for holding data for RNA, DNA, SNP and Copy Number Variation
measurements respectively, with associated \code{fData} and \code{pData}
containing the row and column metadata}

\item{\code{sample}}{A \code{data.frame} containg the annotations for all the cell
lines profiled in the data set, across all data types}

\item{\code{treatment}}{A \code{data.frame} containg the annotations for all the
radiation treatment types used in the in the dataset, across all data types}

\item{\code{sensitivity}}{A \code{list} containing all the data for the sensitivity
experiments, including \code{$info}, a \code{data.frame} containing the
experimental info,\code{$raw} a 3D \code{array} containing raw data,
\code{$profiles}, a \code{data.frame} containing sensitivity profiles
statistics, and \code{$n}, a \code{data.frame} detailing the number of
experiments for each cell-radiation type pair}

\item{\code{perturbation}}{A \code{list} containting \code{$n}, a \code{data.frame}
summarizing the available perturbation data,}

\item{\code{curation}}{A \code{list} containing mappings for
\code{cell} and \code{tissue} names used in the data set to universal
identifiers used between different RadioSet objects}

\item{\code{datasetType}}{A \code{character} string of 'sensitivity',
'perturbation', or both detailing what type of data can be found in the
RadioSet, for proper processing of the data}
}}

