% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RadioSet-accessors.R
\name{RadioSet-accessors}
\alias{RadioSet-accessors}
\alias{radiationInfo}
\alias{treatmentInfo,RadioSet-method}
\alias{treatmentInfo}
\alias{radiationInfo<-}
\alias{treatmentInfo<-,RadioSet,data.frame-method}
\alias{treatmentInfo<-}
\alias{radiationTypes}
\alias{treatmentNames,RadioSet-method}
\alias{treatmentNames}
\alias{radiationTypes<-}
\alias{treatmentNames<-,RadioSet,character-method}
\alias{treatmentNames<-}
\alias{annotation,RadioSet-method}
\alias{annotation}
\alias{annotation<-,RadioSet,list-method}
\alias{annotation<-}
\alias{dateCreated,RadioSet-method}
\alias{dateCreated}
\alias{dateCreated<-,RadioSet,character-method}
\alias{dateCreated<-,RadioSet-method}
\alias{dateCreated<-}
\alias{name,RadioSet-method}
\alias{name}
\alias{name<-,RadioSet-method}
\alias{name<-,RadioSet,character-method}
\alias{name<-}
\alias{sampleInfo,RadioSet-method}
\alias{sampleInfo}
\alias{cellInfo,RadioSet-method}
\alias{cellInfo}
\alias{sampleInfo<-,RadioSet,data.frame-method}
\alias{sampleInfo<-}
\alias{cellInfo<-,RadioSet,data.frame-method}
\alias{cellInfo<-}
\alias{sampleNames,RadioSet-method}
\alias{sampleName,RadioSet-method}
\alias{sampleNames}
\alias{cellName,RadioSet-method}
\alias{cellNames}
\alias{sampleNames<-,RadioSet,character-method}
\alias{sampleNames<-,RadioSet,list-method}
\alias{sampleNames<-}
\alias{cellNames<-,RadioSet,list-method}
\alias{cellNames<-}
\alias{curation,RadioSet-method}
\alias{curation}
\alias{curation<-,RadioSet,list-method}
\alias{curation<-}
\alias{datasetType,RadioSet-method}
\alias{datasetType}
\alias{datasetType<-,RadioSet,character-method}
\alias{datasetType<-}
\alias{molecularProfiles,RadioSet-method}
\alias{molecularProfiles}
\alias{molecularProfiles<-,RadioSet,character,character,matrix-method}
\alias{molecularProfiles<-,RadioSet,character,missing,matrix-method}
\alias{molecularProfiles<-,RadioSet,missing,missing,list-method}
\alias{molecularProfiles<-,RadioSet,missing,missing,MutliAssayExperiment-method}
\alias{molecularProfiles<-}
\alias{featureInfo,RadioSet-method}
\alias{featureInfo}
\alias{featureInfo<-,RadioSet,character,data.frame-method}
\alias{featureInfo<-,RadioSet,character,DataFrame-method}
\alias{featureInfo<-}
\alias{phenoInfo,RadioSet,character-method}
\alias{phenoInfo}
\alias{phenoInfo<-,RadioSet,character,data.frame-method}
\alias{phenoInfo<-,RadioSet,character,DataFrame-method}
\alias{phenoInfo<-}
\alias{fNames,RadioSet,character-method}
\alias{fNames}
\alias{fNames<-,RadioSet,character,character-method}
\alias{fNames<-}
\alias{mDataNames,RadioSet-method}
\alias{mDataNames}
\alias{mDataNames<-,RadioSet-method}
\alias{mDataNames<-,RadioSet,ANY-method}
\alias{mDataNames<-}
\alias{molecularProfilesSlot,RadioSet-method}
\alias{moleculerProfilesSlot,RadioSet-method}
\alias{molecularProfilesSlot}
\alias{molecularProfilesSlot<-,RadioSet,list_OR_MAE-method}
\alias{molecularProfilesSlot<-,RadioSet,list-method}
\alias{molecularProfilesSlot<-RadioSet,MultiAssayExperiment-method}
\alias{molecularProfilesSlot<-}
\alias{sensitivityInfo,RadioSet-method}
\alias{sensitivityInfo,RadioSet,missing-method}
\alias{sensitivityInfo,RadioSet,character-method}
\alias{sensitivityInfo<-,RadioSet,data.frame-method}
\alias{sensitivityInfo<-,RadioSet,missing,data.frame-method}
\alias{sensitvityInfo<-,RadioSet,character,data.frame-method}
\alias{sensitivityMeasures,RadioSet-method}
\alias{sensitivityMeasures<-,RadioSet,character-method}
\alias{sensitivityProfiles,RadioSet-method}
\alias{sensitivityProfiles<-,RadioSet,data.frame-method}
\alias{sensitivityRaw,RadioSet-method}
\alias{sensitivityRaw<-,RadioSet,array-method}
\alias{treatmentResponse,RadioSet-method}
\alias{treatmentResponse}
\alias{sensitivitySlot}
\alias{treatmentResponse<-,RadioSet,list_OR_LongTable-method}
\alias{treatmentResponse<-}
\alias{treamentResponse<-,RadioSet,list-method}
\alias{treatmentResponse<-,RadioSet,LongTable-method}
\alias{sensitivitySlot<-}
\alias{sensNumber,RadioSet-method}
\alias{sensNumber}
\alias{sensNumber<-,RadioSet,matrix-method}
\alias{sensNumber<-}
\alias{pertNumber,RadioSet-method}
\alias{pertNumber}
\alias{pertNumber<-,RadioSet,array-method}
\alias{pertNumber<-}
\title{Accessing and modifying information in a `RadioSet`}
\usage{
radiationInfo(...)

radiationInfo(...) <- value

radiationTypes(...)

radiationTypes(...) <- value

\S4method{annotation}{RadioSet}(object)

\S4method{annotation}{RadioSet,list}(object) <- value

\S4method{dateCreated}{RadioSet}(object)

\S4method{dateCreated}{RadioSet,character}(object) <- value

\S4method{name}{RadioSet}(object)

\S4method{name}{RadioSet}(object) <- value

\S4method{sampleInfo}{RadioSet}(object)

\S4method{sampleInfo}{RadioSet,data.frame}(object) <- value

\S4method{sampleNames}{RadioSet}(object)

\S4method{sampleNames}{RadioSet,character}(object) <- value

\S4method{curation}{RadioSet}(object)

\S4method{curation}{RadioSet,list}(object) <- value

\S4method{datasetType}{RadioSet}(object)

\S4method{datasetType}{RadioSet,character}(object) <- value

\S4method{molecularProfiles}{RadioSet}(object, mDataType, assay)

\S4method{molecularProfiles}{RadioSet,character,character,matrix}(object, mDataType, assay) <- value

\S4method{featureInfo}{RadioSet}(object, mDataType)

\S4method{featureInfo}{RadioSet,character,data.frame}(object, mDataType) <- value

\S4method{phenoInfo}{RadioSet,character}(object, mDataType)

\S4method{phenoInfo}{RadioSet,character,data.frame}(object, mDataType) <- value

\S4method{fNames}{RadioSet,character}(object, mDataType)

\S4method{fNames}{RadioSet,character,character}(object, mDataType) <- value

\S4method{mDataNames}{RadioSet}(object)

\S4method{mDataNames}{RadioSet}(object) <- value

\S4method{molecularProfilesSlot}{RadioSet}(object)

\S4method{molecularProfilesSlot}{RadioSet,list_OR_MAE}(object) <- value

\S4method{sensitivityInfo}{RadioSet}(object, dimension, ...)

\S4method{sensitivityInfo}{RadioSet,data.frame}(object, dimension, ...) <- value

\S4method{sensitivityMeasures}{RadioSet}(object)

\S4method{sensitivityMeasures}{RadioSet,character}(object) <- value

\S4method{sensitivityProfiles}{RadioSet}(object)

\S4method{sensitivityProfiles}{RadioSet,data.frame}(object) <- value

\S4method{sensitivityRaw}{RadioSet}(object)

\S4method{sensitivityRaw}{RadioSet,array}(object) <- value

\S4method{treatmentResponse}{RadioSet}(object)

\S4method{treatmentResponse}{RadioSet,list_OR_LongTable}(object) <- value

\S4method{sensNumber}{RadioSet}(object)

\S4method{sensNumber}{RadioSet,matrix}(object) <- value

\S4method{pertNumber}{RadioSet}(object)

\S4method{pertNumber}{RadioSet,array}(object) <- value
}
\arguments{
\item{...}{See details.}

\item{value}{See details.}

\item{object}{A `RadioSet` object.}

\item{mDataType}{`character(1)` The name of a molecular datatype to access
from the `molecularProfiles` of a `RadioSet` object.}

\item{assay}{`character(1)` A valid assay name in the `SummarizedExperiment`
of `@molecularProfiles` of a RadioSet object for data type `mDataType`.}

\item{dimension}{See details.}
}
\value{
Accessors: See details.

Setters: An updated `RadioSet` object, returned invisibly.
}
\description{
Documentation for the various setters and getters which allow manipulation
of data in the slots of a `RadioSet` object.
}
\details{
\strong{treatmentInfo}: \code{data.frame} Metadata for all treatments in a \code{RadioSet}
object. Arguments:
\itemize{
\item object: \code{RadioSet} An object to retrieve treatment metadata from.
}

\strong{treatmentInfo<-}: \code{RadioSet} object with updated treatment metadata.
object. Arguments:
\itemize{
\item object: \code{RadioSet} An object to set treatment metadata for.
\item value: \code{data.frame} A new table of treatment metadata for \code{object}.
}

\strong{treatmentNames}: \code{character} Names for all treatments in a \code{RadioSet}
object. Arguments:
\itemize{
\item object: \code{RadioSet} An object to retrieve treatment names from.
}

\strong{treatmentNames<-}: \code{RadioSet} Object with updates treatment names.
object. Arguments:
\itemize{
\item object: \code{RadioSet} An object to set treatment names from.
\item value: \code{character} A character vector of updated treatment names.
}

\subsection{@annotation}{

\strong{annotation}: A \code{list} of RadioSet annotations with items: 'name',
the name of the object; 'dateCreated', date the object was created; 'sessionInfo',
the \code{sessionInfo()} when the object was created; 'call', the R constructor call;
and 'version', the object version.
}

\strong{annotation<-}: Setter method for the annotation slot. Arguments:
\itemize{
\item value: a \code{list} of annotations to update the RadioSet with.
}

\subsection{@dateCreated}{

\strong{dateCreated}: \code{character(1)} The date the \code{RadioSet} object was
created, as returned by the \code{date()} function.
}

\strong{dateCreated<-}: Update the 'dateCreated' item in the \code{annotation} slot of
a \code{RadioSet} object. Arguments:
\itemize{
\item value: A \code{character(1)} vector, as returned by the \code{date()} function.
}

\strong{name}: \code{character(1)} The name of the \code{RadioSet}, retreived from
the \verb{@annotation} slot.

\strong{name<-}: Update the \verb{@annotation$name} value in a \code{RadioSet}  object.
\itemize{
\item value: \code{character(1)} The name of the \code{RadioSet} object.
}

\strong{cellInfo}: \code{data.frame} Metadata for all sample in a \code{RadioSet} object.

\strong{sampleInfo<-}: assign updated sample annotations to the \code{RadioSet}
object.
Arguments:
\itemize{
\item value: a \code{data.frame} object.
}

\strong{sampleNames}: \code{character} Retrieve the rownames of the \code{data.frame} in
the \code{sample} slot from a RadioSet object.

\strong{sampleNames<-}: assign new rownames to the sampleInfo \code{data.frame} for
a RadioSet object.
Arguments:
\itemize{
\item value: \code{character} vector of rownames for the \code{sampleInfo(object)} \code{data.frame}.
}

\subsection{@curation}{

\strong{curation}: A \code{list} of curated mappings between identifiers in the
RadioSet object and the original data publication. Contains three \code{data.frame}s, 'cell' with
cell-line ids and 'tissue' with tissue ids and 'radiation' with radiation ids.
}

\strong{curation<-}: Update the \code{curation} slot of a RadioSet object. Arugments:
\itemize{
\item value: A \code{list} of \code{data.frame}s, one for each type of curated
identifier. For a \code{RadioSet} object the slot should
contain tissue, cell-line and radiation id \code{data.frame}s.
}

\subsection{datasetType slot}{

\strong{datasetType}: \code{character(1)} The type treatment response in the
\code{sensitivity} slot. Valid values are 'sensitivity', 'perturbation' or 'both'.
}

\strong{datasetType<-}: Update the datasetType slot of a RadioSet object.
Arguments:
\itemize{
\item value: A \code{character(1)} vector with one of 'sensitivity', 'perturbation'
or 'both'
}

\subsection{@molecularProfiles}{

\strong{molecularProfiles}: \code{matrix()} Retrieve an assay in a
\code{SummarizedExperiment} from the \code{molecularProfiles} slot of a \code{RadioSet}
object with the specified \code{mDataType}. Valid \code{mDataType} arguments can be
found with \code{mDataNames(object)}. Exclude \code{mDataType} and \code{assay} to
access the entire slot. Arguments:
\itemize{
\item assay: Optional \code{character(1)} vector specifying an assay in the
\code{SummarizedExperiment} of the \code{molecularProfiles} slot of the
\code{RadioSet} object for the specified \code{mDataType}. If excluded,
defaults to modifying the first assay in the \code{SummarizedExperiment} for
the given \code{mDataType}.
}
}

\strong{molecularProfiles<-}: Update an assay in a \code{SummarizedExperiment} from
the \code{molecularProfiles} slot of a RadioSet object with the specified
\code{mDataType}. Valid \code{mDataType} arguments can be found with
\code{mDataNames(object)}. Omit \code{mDataType} and \code{assay} to update the slot.
\itemize{
\item assay: Optional \code{character(1)} vector specifying an assay in the
\code{SummarizedExperiment} of the \code{molecularProfiles} slot of the
\code{RadioSet} object for the specified \code{mDataType}. If excluded,
defaults to modifying the first assay in the \code{SummarizedExperiment} for
the given \code{mDataType}.
\item value: A \code{matrix} of values to assign to the \code{assay} slot of the
\code{SummarizedExperiment} for the selected \code{mDataType}. The rownames and
column names must match the associated \code{SummarizedExperiment}.
}

\strong{featureInfo}: Retrieve a \code{DataFrame} of feature metadata for the specified
\code{mDataType} from the \code{molecularProfiles} slot of a \code{RadioSet} object. More
specifically, retrieve the \verb{@rowData} slot from the \code{SummarizedExperiment}
from the \verb{@molecularProfiles} of a \code{RadioSet} object with the name
\code{mDataType}.

__featureInfo<-__: Update the `featureInfo(object, mDataType)` `DataFrame`
with new feature metadata. Arguments:
- value: A `data.frame` or `DataFrame` with updated feature metadata for
the specified molecular profile in the `molecularProfiles` slot of a
`RadioSet` object.

\strong{phenoInfo}: Return the \verb{@colData} slot from the \code{SummarizedExperiment} of
\code{mDataType}, containing sample-level metadata, from a \code{RadioSet} object.

\strong{phenoInfo<-}: Update the \verb{@colData} slot of the \code{SummarizedExperiment}
of \code{mDataType} in the \verb{@molecularProfiles} slot of a \code{RadioSet} object.
This updates the sample-level metadata in-place.
\itemize{
\item value: A \code{data.frame} or \code{DataFrame} object where rows are samples
and columns are sample metadata.
}

\strong{fNames}: \code{character()} The features names from the \code{rowData} slot of a
\code{SummarizedExperiment} of \code{mDataType} within a \code{RadioSet} object.

\strong{fNames}: Updates the rownames of the feature metadata (i.e., \code{rowData})
for a \code{SummarizedExperiment} of \code{mDataType} within a \code{RadioSet} object.
\itemize{
\item value: \code{character()} A character vector of new features names for the
\code{rowData} of the \code{SummarizedExperiment} of \code{mDataType} in the
\verb{@molecularProfiles} slot of a \code{RadioSet} object. Must be the same
length as \code{nrow(featureInfo(object, mDataType))},
the number of rows in the feature metadata.
}

\strong{mDataNames}: \code{character} Retrieve the names of the molecular data types
available in the \code{molecularProfiles} slot of a \code{RadioSet} object. These
are the options which can be used in the \code{mDataType} parameter of various
\code{molecularProfiles} slot accessors methods.

\strong{mDataNames}: Update the molecular data type names of the
\code{molecularProfiles} slot of a RadioSet object. Arguments:
\itemize{
\item value: \code{character} vector of molecular datatype names, with length
equal to \code{length(molecularProfilesSlot(object))}.
}

\strong{molecularProfilesSlot}: Return the contents of the \verb{@molecularProfiles}
slot of a \code{RadioSet} object. This will either be a \code{list} or
\code{MultiAssayExperiment} of \code{SummarizedExperiment}s.

\strong{molecularProfilesSlot<-}: Update the contents of the \verb{@molecularProfiles}
slot of a \code{RadioSet} object. Arguemnts:
\itemize{
\item value: A \code{list} or \code{MultiAssayExperiment} of \code{SummarizedExperiment}s. The
\code{list} and \code{assays} should be named for the molecular datatype in each
\code{SummarizedExperiment}.
}

\subsection{@treatmentResponse}{
\subsection{Arguments:}{
\itemize{
\item \code{dimension}: Optional \code{character(1)} One of 'treatment', 'sample' or
'assay' to retrieve \code{rowData}, \code{colData} or the 'assay_metadata' assay from
the \code{RadioSet} \verb{@sensitvity} \code{LongTable} object, respectively. Ignored with
warning if \verb{@treatmentResponse} is not a \code{LongTable} object.
\item \code{...}: Additional arguments to the \code{rowData} or \code{colData}.
\code{LongTable} methods. Only used if the sensitivity slot contains a
\code{LongTable} object instead of a \code{list} and the \code{dimension} argument is
specified.
}
}

\subsection{Methods:}{

\strong{sensitivityInfo}: \code{DataFrame} or \code{data.frame} of sensitivity treatment combo
by sample metadata for the \code{RadioSet} object. When the \code{dimension}
parameter is used, it allows retrieval of the dimension specific metadata
from the \code{LongTable} object in \verb{@treatmentResponse} of a RadioSet object.
}

}

\strong{sensitivityInfo}<-: Update the \verb{@treatmentResponse} slot metadata for a
\code{RadioSet} object. When used without the \code{dimension} argument is behaves
similar to the old RadioSet implementation, where the \verb{@treatmentResponse} slot
contained a list with a \verb{$info} \code{data.frame} item. When the \code{dimension}
arugment is used, more complicated assignments can occur where 'sample'
modifies the \verb{@sensitvity} \code{LongTable} colData, 'treatment' the rowData and
'assay' the 'assay_metadata' assay.
Arguments:
\itemize{
\item value: A \code{data.frame} of treatment response experiment metadata,
documenting experiment level metadata (mapping to treatments and samples). If
the \verb{@treatmentResponse} slot doesn't contain a \code{LongTable} and \code{dimension} is
not specified, you can only modify existing columns as returned by
\code{sensitivityInfo(object)}.
}

\strong{sensitivityMeaures}: Get the 'sensitivityMeasures' available in a \code{RadioSet}
object. Each measure reprents some summary of sample sensitivity to a given
treatment, such as ic50, ec50, AUC, AAC, etc. The results are returned as a
\code{character} vector with all available metrics for the PSet object.

\strong{sensitivityMeaures}: Update the sensitivity meaure in a \code{RadioSet}
object. Thesee values are the column names of the 'profiles' assay and
represent various compued sensitviity metrics such as ic50, ec50, AUC, AAC,
etc.
\itemize{
\item value: A \code{character} vector of new sensitivity measure names, the
then length of the character vector must matcht he number of columns of the
'profiles' assay, excluding metadata and key columns.
}

\strong{sensitivityProfiles}: Return the sensitivity profile summaries from the
sensitivity slot. This data.frame cotanins vaarious sensitivity summary
metrics, such as ic50, amax, EC50, aac, HS, etc as columns, with rows as
treatment by sample experiments.

\strong{sensitivityProfiles<-}: Update the sensitivity profile summaries the
sensitivity slot. Arguments:
-value: A \code{data.frame} the the same number of rows as as returned by
\code{sensitivityProfiles(object)}, but potentially modified columns, such as the
computation of additional summary metrics.

\strong{sensitivityRaw}: Access the raw sensitiity measurents for a RadioSet
object. A 3D \code{array} where rows are experiment_ids, columns are doses
and the third dimension is metric, either 'Dose' for the doses used or
'Viability' for the sample viability at that dose.

\strong{sensitvityRaw<-}: Update the raw dose and viability data in a \code{RadioSet}.
\itemize{
\item value: A 3D \code{array} object where rows are experiment_ids, columns are
replicates and pages are c('Dose', 'Viability'), with the corresponding
dose or viability measurement for that experiment_id and replicate.
}

\strong{sensNumber}: Return a count of viability observations in a \code{RadioSet}
object for each treatment-combo by sample combination.

\strong{sensNumber<-}: Update the 'n' item, which holds a matrix with a count
of treatment by sample-line experiment counts, in the \code{list} in \verb{@treatmentResponse}
slot of a \code{RadioSet} object. Will error when \verb{@sensitviity} contains
a \code{LongTable} object, since the counts are computed on the fly. Arguments:
\itemize{
\item value: A \code{matrix} where rows are samples and columns are treatments, with a
count of the number of experiments for each combination as the values.
}

\strong{pertNumber}: \code{array} Summary of available perturbation experiments
from in a \code{RadioSet} object. Returns a 3D \code{array} with the number of
perturbation experiments per treatment and sample, and data type.

\strong{pertNumber<-}: Update the \verb{@perturbation$n} value in a \code{RadioSet} object,
which stores a summary of the available perturbation experiments. Arguments:
\itemize{
\item value: A new 3D \code{array} with the number of perturbation experiments per
treatment and sample, and data type
}
}
\examples{
data(clevelandSmall)
treatmentInfo(clevelandSmall)

treatmentInfo(clevelandSmall) <- treatmentInfo(clevelandSmall)

treatmentNames(clevelandSmall)

treatmentNames(clevelandSmall) <- treatmentNames(clevelandSmall)


## @annotation

annotation(clevelandSmall)

annotation(clevelandSmall) <- annotation(clevelandSmall)

dateCreated(clevelandSmall)

## dateCreated
dateCreated(clevelandSmall) <- date()

name(clevelandSmall)

name(clevelandSmall) <- 'new_name'

sampleInfo(clevelandSmall) <- sampleInfo(clevelandSmall)

sampleNames(clevelandSmall)

sampleNames(clevelandSmall) <- sampleNames(clevelandSmall)

## curation
curation(clevelandSmall)

curation(clevelandSmall) <- curation(clevelandSmall)

datasetType(clevelandSmall)

datasetType(clevelandSmall) <- 'both'

# No assay specified
molecularProfiles(clevelandSmall, 'rna') <- molecularProfiles(clevelandSmall, 'rna')

# Specific assay
molecularProfiles(clevelandSmall, 'rna', 'exprs') <-
    molecularProfiles(clevelandSmall, 'rna', 'exprs')

# Replace the whole slot
molecularProfiles(clevelandSmall) <- molecularProfiles(clevelandSmall)

featureInfo(clevelandSmall, 'rna')

featureInfo(clevelandSmall, 'rna') <- featureInfo(clevelandSmall, 'rna')

phenoInfo(clevelandSmall, 'rna')

phenoInfo(clevelandSmall, 'rna') <- phenoInfo(clevelandSmall, 'rna')

fNames(clevelandSmall, 'rna')

fNames(clevelandSmall, 'rna') <- fNames(clevelandSmall, 'rna')

mDataNames(clevelandSmall)

mDataNames(clevelandSmall) <- mDataNames(clevelandSmall)

molecularProfilesSlot(clevelandSmall)

molecularProfilesSlot(clevelandSmall) <- molecularProfilesSlot(clevelandSmall)

sensitivityInfo(clevelandSmall)

sensitivityInfo(clevelandSmall) <- sensitivityInfo(clevelandSmall)

sensitivityMeasures(clevelandSmall) <- sensitivityMeasures(clevelandSmall)

sensitivityMeasures(clevelandSmall) <- sensitivityMeasures(clevelandSmall)

sensitivityProfiles(clevelandSmall)

sensitivityProfiles(clevelandSmall) <- sensitivityProfiles(clevelandSmall)

head(sensitivityRaw(clevelandSmall))

sensitivityRaw(clevelandSmall) <- sensitivityRaw(clevelandSmall)

treatmentResponse(clevelandSmall)

treatmentResponse(clevelandSmall) <- treatmentResponse(clevelandSmall)

sensNumber(clevelandSmall)

sensNumber(clevelandSmall) <- sensNumber(clevelandSmall)

pertNumber(clevelandSmall)

pertNumber(clevelandSmall) <- pertNumber(clevelandSmall)

}
