% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECDFPlot.R
\name{ECDFPlot}
\alias{ECDFPlot}
\title{Plot empirical cumulative distribution function for correlations.}
\usage{
ECDFPlot(X, Y, index = "all", col.X = "red", col.Y = "black", title, legend)
}
\arguments{
\item{X}{A matrix or list of matrices of estimated gene-gene correlations.}

\item{Y}{A matrix of reference gene-gene correlations (i.e. 
underlying known correlation structure).}

\item{index}{A vector of indicies of genes of interest.}

\item{col.X}{The color or colors for ECDF as estimated from \code{X}.}

\item{col.Y}{The color for ECDF as estimated from \code{Y}.}

\item{title}{A character string describing title of plot.}

\item{legend}{A vector describing \code{X} and \code{Y}.}
}
\value{
\code{ECDFPlot} returns a plot.
}
\description{
\code{ECDFPlot} generates empirical cumulative distribution 
functions (ECDF) for gene-gene correlation values.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=FALSE, check.input=FALSE)
Y.hat<-RUVNaiveRidge(Y, center=TRUE, nc_index=251:500, 0, 10, check.input=TRUE)
Y.hat.cor<-cor(Y.hat)
par(mar=c(5.1, 4.1, 4.1, 2.1), mgp=c(3, 1, 0), las=0, mfrow=c(1, 1))
ECDFPlot(Y.hat.cor, Y$Sigma, index=1:100, title="Simulated data", 
legend=c("RUV", "Truth"))
ECDFPlot(list(Y.hat.cor, cor(Y$Y)), Y$Sigma, index=1:100, 
title="Simulated data", legend=c("RUV", "Raw", "Truth"), col.Y="black")

}
\author{
Saskia Freytag
}
