% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful_functions.R
\name{calc_mean_DNA}
\alias{calc_mean_DNA}
\title{Calculated mean of normalised Iridium isotopes}
\usage{
calc_mean_DNA(sce, name_assay = "counts", dna_channels, q)
}
\arguments{
\item{sce}{A SingleCellExperiment object with markers and SUCs in linear scale stored in the assay "name_assay". Asinh transformation is applied within the function.}

\item{name_assay}{A string specifying the name of the assay including the DNA channels in linear scale.}

\item{dna_channels}{Vector specifying the names of the DNA channels}

\item{q}{Quantile for normalisation.}
}
\value{
The SingleCellExperiment object with an extra column "mean_BC" in the corresponding assay.
}
\description{
Calculated mean of normalised Iridium isotopes
}
\examples{
sce <- RUCova::sce
dna_channels <- c("DNA_191Ir", "DNA_193Ir")
sce <- RUCova::calc_mean_DNA(sce, name_assay = "counts", dna_channels, q = 0.95)
}
