% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLinks.R
\name{getLinks}
\alias{getLinks}
\title{Get resource links from inputs}
\usage{
getLinks(
  dataset,
  data_date = "20160128",
  RNASeqGene = FALSE,
  RNASeq2Gene = FALSE,
  clinical = FALSE,
  miRNASeqGene = FALSE,
  RNASeq2GeneNorm = FALSE,
  RNAseq2Norm = c("normalized_counts", "RSEM_normalized_log2", "raw_counts",
    "scaled_estimate"),
  CNASNP = FALSE,
  CNVSNP = FALSE,
  CNASeq = FALSE,
  CNACGH = FALSE,
  Methylation = FALSE,
  Mutation = FALSE,
  mRNAArray = FALSE,
  miRNAArray = FALSE,
  RPPAArray = FALSE,
  GISTIC = FALSE
)
}
\arguments{
\item{dataset}{A cohort disease code. TCGA cancer codes can be obtained via
\link{getFirehoseDatasets}}

\item{data_date}{Either a runDate or analysisDate typically entered in
\code{getFirehoseData}}

\item{RNASeqGene}{Logical (default FALSE) RNAseq TPM data.}

\item{RNASeq2Gene}{Logical (default FALSE) RNAseq v2 (RSEM processed) data;
see \code{RNAseqNorm} argument.}

\item{clinical}{Logical (default TRUE) clinical data.}

\item{miRNASeqGene}{Logical (default FALSE) smallRNAseq data.}

\item{RNASeq2GeneNorm}{Logical (default FALSE) RNAseq v2 (RSEM processed)
data.}

\item{RNAseq2Norm}{RNAseq v2 data normalization method. (Default
normalized_count or one of RSEM_normalized_log2, raw_count,
scaled_estimate)}

\item{CNASNP}{Logical (default FALSE) somatic copy number alterations data
from SNP array.}

\item{CNVSNP}{Logical (default FALSE) germline copy number variants data from
SNP array.}

\item{CNASeq}{Logical (default FALSE) somatic copy number alterations data
from sequencing.}

\item{CNACGH}{Logical (default FALSE) somatic copy number alterations data
from CGH.}

\item{Methylation}{Logical (default FALSE) methylation data.}

\item{Mutation}{Logical (default FALSE) mutation data from sequencing.}

\item{mRNAArray}{Logical (default FALSE) mRNA expression data from
microarray.}

\item{miRNAArray}{Logical (default FALSE) miRNA expression data from
microarray.}

\item{RPPAArray}{Logical (default FALSE) RPPA data}

\item{GISTIC}{logical (default FALSE) processed copy number data}
}
\value{
A character URL to a dataset location
}
\description{
This function provides a reference to the resources downloaded from the
GDAC Firehose pipeline. Based on the input, the function returns a
URL location to the resource if there exists one.
}
\examples{

getLinks("BRCA", CNASeq = TRUE)

}
