RPA
===

Robust Probabilistic Averaging (RPA) is a Bioconductor R package for
probe-level preprocessing and analysis of short oligonucleotide
arrays. The tools are generic but special wrappers are available for
Affymetrix gene expression arrays as well as phylogenetic microarrays
(HITChip in particular). 

This Github repository is the home for the latest development version.
For the release version, see [RPA Bioconductor
page](http://bioconductor.org/packages/release/bioc/html/RPA.html)


### Installation and use

The installation instructions and working examples are in
[RPA wiki](https://github.com/antagomir/RPA/wiki).


### Contents of this directory

This directory contains the following:

 * The R package structure (development version)
 * [inst/extras/misc](inst/extras/misc) Miscellaneous development and test code
 * [inst/extras/NAR2013](inst/extras/NAR2013) Some scripts used for the [NAR 2013](http://nar.oxfordjournals.org/content/41/10/e110) paper

### Citing RPA

The work has been documented in these two publications. Kindly cite if
appropriate:

 * [A fully scalable online pre-processing algorithm for short oligonucleotide microarray atlases](http://nar.oxfordjournals.org/content/41/10/e110) Leo Lahti, Aurora Torrente, Laura L Elo, Alvis Brazma, Johan Rung. _Nucleic Acids Research'_ 41(10):e110, 2013. 

 * [Probabilistic analysis of probe reliability in differential gene expression studies with short oligonucleotide arrays](https://www.researchgate.net/publication/224439493_Probabilistic_Analysis_of_Probe_Reliability_in_Differential_Gene_Expression_Studies_with_Short_Oligonucleotide_Arrays/file/9fcfd4fbe8b3e5387a.pdf) Leo Lahti, Laura L. Elo, Tero Aittokallio, and Samuel Kaski. _IEEE/ACM Transactions on Computational Biology and Bioinformatics_ 8(1):217-25, 2011. 

 * [Robust Probabilistic Analysis (RPA)](http://bioconductor.org/packages/release/bioc/html/RPA.html). Bioconductor package. Leo Lahti, 2013. URL: http://bioconductor.org/packages/release/bioc/html/RPA.html 


RPA has also been used in the context of phylogenetic microarrays, see
for instance:

  * [Tipping elements in the human intestinal ecosystem](http://www.nature.com/ncomms/2014/140708/ncomms5344/full/ncomms5344.html)







