% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceData-normalized-end-pos.R
\docType{class}
\name{NormEndSequenceData-class}
\alias{NormEndSequenceData-class}
\alias{NormEnd5SequenceData}
\alias{NormEnd3SequenceData}
\alias{NormEnd5SequenceDataFrame-class}
\alias{NormEnd5SequenceDataFrame}
\alias{NormEnd5SequenceData-class}
\alias{NormEnd3SequenceDataFrame-class}
\alias{NormEnd3SequenceDataFrame}
\alias{NormEnd3SequenceData-class}
\alias{getData,NormEnd5SequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam-method}
\alias{getData,NormEnd3SequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam-method}
\alias{aggregateData,NormEnd5SequenceData-method}
\alias{aggregateData,NormEnd3SequenceData-method}
\alias{getDataTrack,NormEnd5SequenceData-method}
\alias{getDataTrack,NormEnd3SequenceData-method}
\title{NormEnd5SequenceData/NormEnd3SequenceData}
\usage{
NormEnd5SequenceDataFrame(
  df,
  ranges,
  sequence,
  replicate,
  condition,
  bamfiles,
  seqinfo
)

NormEnd3SequenceDataFrame(
  df,
  ranges,
  sequence,
  replicate,
  condition,
  bamfiles,
  seqinfo
)

NormEnd5SequenceData(bamfiles, annotation, sequences, seqinfo, ...)

NormEnd3SequenceData(bamfiles, annotation, sequences, seqinfo, ...)

\S4method{getData}{NormEnd5SequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam}(x, bamfiles, grl, sequences, param, args)

\S4method{getData}{NormEnd3SequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam}(x, bamfiles, grl, sequences, param, args)

\S4method{aggregateData}{NormEnd5SequenceData}(x, condition = c("Both", "Treated", "Control"))

\S4method{aggregateData}{NormEnd3SequenceData}(x, condition = c("Both", "Treated", "Control"))

\S4method{getDataTrack}{NormEnd5SequenceData}(x, name, ...)

\S4method{getDataTrack}{NormEnd3SequenceData}(x, name, ...)
}
\arguments{
\item{df, ranges, sequence, replicate}{inputs for creating a 
\code{SequenceDataFrame}. See 
\code{\link[=SequenceDataFrame-class]{SequenceDataFrame}}.}

\item{condition}{For \code{\link{aggregate}}: condition for which the data 
should be aggregated.}

\item{bamfiles, annotation, seqinfo, grl, sequences, param, args, ...}{See 
\code{\link[=SequenceData-class]{SequenceData}} and
\code{\link[=SequenceData-functions]{SequenceData-functions}}}

\item{x}{a \code{CoverageSequenceData}}

\item{name}{For \code{\link[=plotDataByCoord]{getDataTrack}}: a valid 
transcript name. Must be a name of \code{ranges(x)}}
}
\value{
a \code{NormEnd5SequenceData} or \code{NormEnd3SequenceData} object
}
\description{
The \code{NormEnd5SequenceData}/\code{NormEnd3SequenceData}
aggregate the counts of read ends (Either 5' or 3') at each position along a
transcript. In addition, the number of counts are then normalized to the
length of the transcript and to the overlapping reads.

Both classes contain three columns per data file named using the
following naming convention \code{(normend5/normend3).condition.replicate}.
The three columns are distinguished by additional identifiers \code{ends},
\code{norm.tx} and \code{norm.ol}.

\code{aggregate} calculates the mean and sd for samples in the \code{control}
and \code{treated} condition separatly. Similar to the stored results for 
each of the two conditions six columns are returned (three for mean and sd 
each) ending in \code{ends}, \code{tx} and \code{ol}.
}
\examples{
# Construction of a NormEnd5SequenceData object
\dontrun{
library(RNAmodR.Data)
library(rtracklayer)
annotation <- GFF3File(RNAmodR.Data.example.man.gff3())
sequences <- RNAmodR.Data.example.man.fasta()
files <- c(treated = RNAmodR.Data.example.wt.1())
ne5sd <- NormEnd5SequenceData(files, annotation = annotation,
                              sequences = sequences)
}
}
