% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModifierSet-class.R
\docType{class}
\name{ModifierSet-class}
\alias{ModifierSet-class}
\alias{ModifierSet}
\alias{ModifierSet,list-method}
\alias{ModifierSet,character-method}
\alias{ModifierSet,BamFileList-method}
\alias{ModifierSet,Modifier-method}
\title{The ModifierSet class}
\usage{
ModifierSet(className, x, annotation, sequences, seqinfo, ...)

\S4method{ModifierSet}{list}(
  className,
  x,
  annotation = NULL,
  sequences = NULL,
  seqinfo = NULL,
  ...
)

\S4method{ModifierSet}{character}(
  className,
  x,
  annotation = NULL,
  sequences = NULL,
  seqinfo = NULL,
  ...
)

\S4method{ModifierSet}{BamFileList}(
  className,
  x,
  annotation = NULL,
  sequences = NULL,
  seqinfo = NULL,
  ...
)

\S4method{ModifierSet}{Modifier}(className, x, annotation, sequences, seqinfo, ...)
}
\arguments{
\item{className}{The name of the class which should be constructed.}

\item{x}{the input which can be of the following types
\itemize{
\item \code{Modifier}: a single \code{Modifier} or a list containg only 
\code{Modifier} objects. The input will just be used as elements of the
\code{ModifierSet}
\item \code{BamFileList}: a named \code{BamFileList} or a list of 
named \code{BamFileList}
\item \code{list}: a list of one or more types of elements: 
\code{BamFileList}, a named \code{list} or named \code{character} vector. All
elements must be or be coercible to a named \code{BamFileList} referencing 
existing bam files. Valid names are \code{control} and \code{treated}
}}

\item{annotation}{annotation data, which must match the information contained
in the BAM files. This is parameter is only required, if \code{x} is not a 
\code{Modifier} object.}

\item{sequences}{sequences matching the target sequences the reads were 
mapped onto. This must match the information contained in the BAM files. This
is parameter is only required, if \code{x} is not a \code{Modifier} object.}

\item{seqinfo}{An optional \code{\link[Seqinfo:Seqinfo-class]{Seqinfo}} 
argument or character vector, which can be coerced to one, to subset the 
sequences to be analyzed on a per chromosome basis.}

\item{...}{Additional otpional parameters:
\itemize{
\item internalBP: \code{TRUE} or \code{FALSE}: should parallelization used
internally during creation of each \code{Modifier} or should the creation of
the \code{Modifier} objects be parallalized? (default: \code{internalBP =
FALSE}). Setting \code{internalBP} only makes sense, if the
\code{\link{getData}} function for \code{\link{SequenceData}} class, the
\code{\link[=aggregate]{aggregateData}} or the \code{\link[=modify]{findMod}}
function contains parallelized code.
}
All other arguments will be passed onto the \code{Modifier} objects.}
}
\value{
a \code{ModifierSet} object of type \code{className}
}
\description{
The \code{ModifierSet} class allows multiple
\code{\link[=Modifier-class]{Modifier}} objects to be created from the same
annotation and sequence data varying only the bam input files.

In addition the comparison of samples is also done via calling functions on 
the \code{ModifierSet} objects.

The \code{ModifierSet} is a virtual class, which derives from the 
\code{SimpleList} class with the slot \code{elementType = "Modifier"}. The
\code{ModifierSet} class has to be implemented for each specific analysis.#'
}
\section{Creation}{

The input files have to be provided as a \code{list} of elements. Each
element in itself must be valid for the creation of \code{\link{Modifier}}
object (Have a look at the man page for more details) and must be named.
}

