% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leMsMs.r
\name{recalibrate.addMS1data}
\alias{recalibrate.addMS1data}
\title{Return MS1 peaks to be used for recalibration}
\usage{
recalibrate.addMS1data(spec, recalibrateMS1Window = 
				getOption("RMassBank")$recalibrateMS1Window)
}
\arguments{
\item{spec}{A \code{msmsWorkspace} or \code{RmbSpectraSetList} containing spectra for which MS1 "peaks" should be "constructed".}

\item{recalibrateMS1Window}{Window width to look for MS1 peaks to recalibrate (in ppm).}
}
\value{
A dataframe with columns \code{mzFound, formula, mzCalc, dppm, dbe, int,
		dppmBest, formulaCount, good, cpdID, scan, parentScan, dppmRc}. However,
		columns \code{dbe, int, formulaCount, good, scan, parentScan} do not contain
		real information and are provided only as fillers.
}
\description{
Returns the precursor peaks for all MS1 spectra in the \code{spec} dataset
with annotated formula to be used in recalibration.
 
For all spectra in \code{spec$specFound}, the precursor ion is extracted from
the MS1 precursor spectrum. All found ions are returned in a data frame with a
format matching \code{spec$peaksMatched} and therefore suitable for \code{rbind}ing
to the \code{spec$peaksMatched} table. However, only minimal information needed for
recalibration is returned.
}
\examples{
\dontrun{
# More or less as used in recalibrateSpectra:
		rcdata <- peaksMatched(w)
		rcdata <- rcdata[rcdata$formulaCount == 1, ,drop=FALSE]
		ms1data <- recalibrate.addMS1data(w, "pH", 15)
		rcdata <- rbind(rcdata, ms1data)
 # ... continue constructing recalibration curve with rcdata
}
}
\author{
Michael Stravs, EAWAG <michael.stravs@eawag.ch>
}
