% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AggregateMethods.R
\name{peaksUnmatched}
\alias{peaksUnmatched}
\alias{peaksUnmatched,data.frame-method}
\alias{peaksUnmatched,msmsWorkspace-method}
\title{Select matching/unmatching peaks from aggregate table}
\usage{
peaksUnmatched(o, cleaned = FALSE)

\S4method{peaksUnmatched}{data.frame}(o, cleaned = FALSE)

\S4method{peaksUnmatched}{msmsWorkspace}(o, cleaned = FALSE)
}
\arguments{
\item{o}{Workspace or aggregate table from a workspace}

\item{cleaned}{Return only peaks which pass electronic noise filtering if \code{TRUE}.}
}
\value{
Selects the peaks from the aggregate table which matched within filter criteria (\code{peaksMatched}) or didn't match
		(\code{peaksUnmatched}).
}
\description{
Select matching/unmatching peaks from aggregate table
}
\section{Methods (by class)}{
\itemize{
\item \code{peaksUnmatched(data.frame)}: A method to retrieve the unmatched peaks from the "aggregated" slot (a data.frame object) in an msmsWorkSpace

\item \code{peaksUnmatched(msmsWorkspace)}: A method to retrieve the unmatched peaks from an msmsWorkSpace

}}
\author{
stravsmi
}
