% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leMsmsRaw.R
\name{findEIC}
\alias{findEIC}
\title{Extract EICs}
\usage{
findEIC(
  msRaw,
  mz,
  limit = NULL,
  rtLimit = NA,
  headerCache = NULL,
  floatingRecalibration = NULL,
  peaksCache = NULL,
  polarity = NA,
  msLevel = 1,
  precursor = NULL
)
}
\arguments{
\item{msRaw}{The mzR file handle}

\item{mz}{The mass or mass range to extract the EIC for: either a single mass
(with the range specified by \code{limit} below) or a mass range
in the form of \code{c(min, max)}.}

\item{limit}{If a single mass was given for \code{mz}: the mass window to extract.
A limit of 0.001 means that the EIC will be returned for \code{[mz - 0.001, mz + 0.001]}.}

\item{rtLimit}{If given, the retention time limits in form \code{c(rtmin, rtmax)} in seconds.}

\item{headerCache}{If present, the complete \code{mzR::header(msRaw)}. Passing
this value is useful if spectra for multiple compounds should be 
extracted from the same mzML file, since it avoids getting the data
freshly from \code{msRaw} for every compound.}

\item{floatingRecalibration}{A fitting function that \code{predict()}s a mass shift based on the retention time. Can be used
if a lockmass calibration is known (however you have to build the calibration yourself.)}

\item{peaksCache}{If present, the complete output of \code{mzR::peaks(msRaw)}. This speeds up the lookup
if multiple compounds should be searched in the same file.}

\item{polarity}{If a value is given, scans are filtered to this polarity before EIC
extraction. Valid values are 1 for positive, 0 for negative (according to mzR), or a RMassBank
`mode` (e.g. `pH, pM, mH...`) from which the polarity can be derived.}

\item{msLevel}{Which MS level to target for EIC extraction. By default this is 1; level 2
can be used to extract the EIC of fragments for a specific precursor or to extract EICs
from DIA data.}

\item{precursor}{Which precursor to target for EIC extraction. If `NULL`, the scans are not 
filtered by precursor. Use this only for `msLevel != 1`. If a `precursor` filter is set for 
`msLevel == 1`, all scans will be filtered out.}
}
\value{
A \code{[rt, intensity, scan]} matrix (\code{scan} being the scan number.)
}
\description{
Extract EICs from raw data for a determined mass window.
}
\seealso{
findMsMsHR
}
\author{
Michael A. Stravs, Eawag <michael.stravs@eawag.ch>
}
