% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Isotopic_Annotation.R
\name{checkIsotopes}
\alias{checkIsotopes}
\title{Checks for isotopes in a \code{msmsWorkspace}}
\usage{
checkIsotopes(
  w,
  mode = "pH",
  intensity_cutoff = 0,
  intensity_precision = "none",
  conflict = "strict",
  isolationWindow = 2,
  evalMode = "complete",
  plotSpectrum = TRUE,
  settings = getOption("RMassBank")
)
}
\arguments{
\item{w}{A \code{msmsWorkspace} to work with.}

\item{mode}{\code{"pH", "pNa", "pM", "pNH4", "mH", "mM", "mFA"} for different ions 
([M+H]+, [M+Na]+, [M]+, [M+NH4]+, [M-H]-, [M]-, [M+FA]-).}

\item{intensity_cutoff}{The cutoff (as an absolute intensity value) under which isotopic peaks shouldn't be checked for or accepted as valid.
Please note: The cutoff is not hard in the sense that it interacts with the intensity_precision parameter.}

\item{intensity_precision}{The difference that is accepted between the calculated and observed intensity of a possible isotopic peak. Further details down below.}

\item{conflict}{Either "isotopic"(Peak formulas are always chosen if they fit the requirements for an isotopic peak)
or "strict"(Peaks are only marked as isotopic when there hasn't been a formula assigned before.)}

\item{isolationWindow}{Half of the width of the isolation window in Da}

\item{evalMode}{Currently no function yet, but planned. Currently must be "complete"}

\item{plotSpectrum}{A boolean specifiying whether the spectrumshould be plotted}

\item{settings}{Options to be used for processing. Defaults to the options loaded via
\code{\link{loadRmbSettings}} et al. Refer to there for specific settings.}
}
\value{
The \code{msmsWorkspace} with annotated isolation peaks
}
\description{
Checks for isotopes in a \code{msmsWorkspace}
}
\details{
text describing parameter inputs in more detail.
\itemize{
 \item{\code{intensity_precision}}{This parameter determines how strict the intensity values should adhere to the calculated intensity in relation to the parent peak.
 Options for this parameter are \code{"none"}, where the intensity is irrelevant, \code{"low"}, which has an error margin of 70\% and \code{"high"}, where the error margin 
 is set to 35\%. The recommended setting is \code{"low"}, but can be changed to adjust to the intensity precision of the mass spectrometer.}
}
}
\author{
Michael Stravs, Eawag <michael.stravs@eawag.ch>

Erik Mueller, UFZ
}
