% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmcMethodsIntern.R
\name{runCHR}
\alias{runCHR}
\title{Run \code{\link{rjmcmc}} on multiples segments and merge results.}
\usage{
runCHR(p, seg, niter, kmax, lambda, ecartmin, ecartmax, minReads,
  adaptNbrIterations, vSeed = -1, saveAsRDS = FALSE, dirOut = "out")
}
\arguments{
\item{p}{a \code{integer}, the position of the segment to treat in a
\code{list} of \code{GRanges}.}

\item{seg}{a \code{list} a \code{GRanges} containing the segments
to be process.}

\item{niter}{a positive \code{integer} or \code{numeric}, the
number of iterations. Non-integer values of
\code{nbrIterations} will be casted to \code{integer} and truncated towards
zero.}

\item{lambda}{a positive \code{numeric}, the theorical mean
of the Poisson distribution. Default: 3.}

\item{minReads}{a positive \code{integer} or \code{numeric}, the minimum
number of reads in a potential canditate region. Non-integer values
of \code{minReads} will be casted to \code{integer} and truncated towards
zero. Default: 5.}

\item{adaptNbrIterations}{a \code{logical} indicating if the number
of iterations must be modified in function of the number of reads.}

\item{vSeed}{a \code{integer}. A seed used when reproducible results are
needed. When a value inferior or equal to zero is given, a random integer
is used. Default: -1.}

\item{saveAsRDS}{a \code{logical}. When \code{TRUE}, a RDS file containing
the complete output of the c++ rjmcmc() function is created.
Default : \code{FALSE}.}

\item{kMax}{a positive \code{integer} or \code{numeric}, the maximum number
of degrees of freedom per region. Non-integer values
of \code{kMax} will be casted to \code{integer} and truncated towards zero.}

\item{minInterval}{a \code{numeric}, the minimum distance between two
nucleosomes.}

\item{maxInterval}{a \code{numeric}, the maximum distance between two
nucleosomes.}

\item{maxLength}{a positive \code{integer} or \code{numeric}, the
length of each segment.}
}
\value{
0.
}
\description{
Run \code{\link{rjmcmc}} on a segment that is contained
in a \code{list} of segments. Files generated by the function are all saved
in a directory specified by user. A RData log file is created when a
segment has been run while the result is saved in a RDS file.

If the same output directory is used more than once, the
\code{\link{rjmcmc}} won't be called for segments that have the à
corresponding RData log file.
}
\examples{

## Load synthetic dataset of reads
data(syntheticNucleosomeReads)

## Use dataset of reads to create GRanges object
sampleGRanges <- GRanges(seqnames = syntheticNucleosomeReads$dataIP$chr,
    ranges = IRanges(start = syntheticNucleosomeReads$dataIP$start,
    end = syntheticNucleosomeReads$dataIP$end),
    strand = syntheticNucleosomeReads$dataIP$strand)

# Segmentation of the reads
seg <- segmentation(sampleGRanges, zeta = 147, delta = 50, maxLength = 1000)
\dontrun{
dir.create("out")
dir.create("out/done")
dir.create("out/results")

runCHR(p=1, seg=seg, niter=1000, kmax=330,lambda=3,
            ecartmin=147, ecartmax=297, minReads=5)}

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
