% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmcMethod.R
\name{mergeAllRDSFilesFromDirectory}
\alias{mergeAllRDSFilesFromDirectory}
\title{Merge nucleosome information from all RDS files present
in a same directory. Beware that only nucleosome information from same
chromosome should be merged together.}
\usage{
mergeAllRDSFilesFromDirectory(directory)
}
\arguments{
\item{directory}{a \code{character}, the
name of the directory (relative or absolute path) containing RDS files. The
RDS files must
contain R object of \code{class} "rjmcmcNucleosomes" or
"rjmcmcNucleosomesMerge".}
}
\value{
a \code{list} of \code{class} "rjmcmcNucleosomesMerge" containing:
\itemize{
    \item k a \code{integer}, the number of nucleosomes.
    \item \code{mu} a \code{GRanges} containing the positions of the
nucleosomes.
}
}
\description{
Merge nucleosome information, from all RDS files present
in a same directory, into one object
of \code{class} "rjmcmcNucleosomesMerge".
}
\examples{

## Use a directory present in the RJMCMC package
directoryWithRDSFiles <- system.file("extdata",
package = "RJMCMCNucleosomes")

## Merge nucleosomes info from RDS files present in directory
## It is assumed that all files present in the directory are nucleosomes
## result for the same chromosome
result <- mergeAllRDSFilesFromDirectory(directoryWithRDSFiles)

## Print the number and the position of the nucleosomes
result$k
result$mu

## Class of the output object
class(result)


}
\author{
Pascal Belleau, Astrid Deschenes
}
