% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RJMCMCNucleosomes.R
\docType{package}
\name{RJMCMCNucleosomes-package}
\alias{RJMCMCNucleosomes-package}
\alias{RJMCMCNucleosomes}
\title{RJMCMCNucleosomes: Bayesian hierarchical model for genome-wide
nucleosome positioning with high-throughput short-read data (MNase-Seq)}
\description{
This package does nucleosome positioning using informative
Multinomial-Dirichlet prior in a t-mixture with reversible jump
estimation of nucleosome positions for genome-wide profiling.
}
\seealso{
\itemize{
    \item \code{\link{rjmcmc}} { for profiling of nucleosome positions for a
    segment}
    \item \code{\link{rjmcmcCHR}} { for profiling of nucleosome positions
    for a large region. The function will take care of spliting and
    merging.}
    \item \code{\link{segmentation}} { for spliting a \code{GRanges}
    containing reads in a list of smaller segments for
    the \code{rjmcmc} function.}
    \item \code{\link{postTreatment}} { for merging closely positioned
    nucleosomes}
    \item \code{\link{mergeRDSFiles}} { for merging nucleosome information
    from selected RDS files.}
    \item \code{\link{plotNucleosomes}} { for generating a graph containing
    the nucleosome positions and the read coverage.}
}
}
\author{
Pascal Belleau,
Rawane Samb,
Astrid Deschênes,
Khader Khadraoui,
Lajmi Lakhal and
Arnaud Droit

Maintainer:
Astrid Deschenes <adeschen@hotmail.com>
}
\keyword{package}
