% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Study.R
\name{loadSerializedStudyData}
\alias{loadSerializedStudyData}
\title{Load the Serialized Data of a Study}
\usage{
loadSerializedStudyData(data_dir, study_id, domain)
}
\arguments{
\item{data_dir}{Path to a file folder where the .rds study files reside}

\item{study_id}{Study indentifier}

\item{domain}{Domain of interest}
}
\value{
A study data object where in all data are structured as classes, domains, variables and values (in CDISC format)
}
\description{
Load the serialzed data (.rds) file of a specific domain of a study study from the directory where 
the file is located
}
\examples{
studies_dir <- system.file("extdata", "ImmPortStudies", package = "RImmPort")
# the folder where the .rds files will be stored
rds_dir <- file.path(studies_dir, "Rds")
# load the serialized data of study `SDY208` 
loadSerializedStudyData(rds_dir, 'SDY208', "Demographics")
}

