% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Study.R
\name{getStudiesWithSpecificAssayData}
\alias{getStudiesWithSpecificAssayData}
\title{Get a list of studies that have specific assay type data}
\usage{
getStudiesWithSpecificAssayData(assay_type, all_study_ids = c("ALL"))
}
\arguments{
\item{assay_type}{Assay Type}

\item{all_study_ids}{List of study indentifiers to search on}
}
\value{
List of study indentifiers
}
\description{
Get a list of studies that have specific assay type data
}
\examples{
library(DBI)
library(sqldf)
studies_dir <- system.file("extdata", "ImmPortStudies", package = "RImmPort")
db_dir <- file.path(studies_dir, "Db")
sqlite_conn <- dbConnect(SQLite(), dbname=file.path(db_dir, "ImmPort.sqlite"))
setImmPortDataSource(sqlite_conn)
study_ids <- getStudiesWithSpecificAssayData("ELISPOT")
}

