% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Study.R
\name{getAssayDataOfStudies}
\alias{getAssayDataOfStudies}
\title{Get specific assay data of one or more studies from the ImmPort database}
\usage{
getAssayDataOfStudies(study_ids, assay_type)
}
\arguments{
\item{study_ids}{List of study indentifiers}

\item{assay_type}{Assay Type}
}
\value{
a list of 1) domain data of specicifc assay technology and 2) any supplemental domain data of the studies
}
\description{
Get specific assay data of one or more studies from the ImmPort database
}
\examples{
library(DBI)
library(sqldf)
studies_dir <- system.file("extdata", "ImmPortStudies", package = "RImmPort")
db_dir <- file.path(studies_dir, "Db")
sqlite_conn <- dbConnect(SQLite(), dbname=file.path(db_dir, "ImmPort.sqlite"))
setImmPortDataSource(sqlite_conn)
elispot_l <- getAssayDataOfStudies("SDY139", "ELISPOT")
if (length(elispot_l) > 0)
  names(elispot_l)
head(elispot_l$zb_df)
}
\author{
Ravi Shankar
}

