% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcRIVER.R
\name{testPosteriors}
\alias{testPosteriors}
\title{Test posterior probabilities of FR given G and E}
\usage{
testPosteriors(Feat, Out, emModel)
}
\arguments{
\item{Feat}{Genomic features (G)}

\item{Out}{Binary values of outlier status (E).}

\item{emModel}{Estimated parameters including beta and theta via EM and
selected lambdas}
}
\value{
test posterior probabilities of FR given new outlier status (E)
        and genomic features (G), P(FR | G, E, beta, theta), and probable
        status of FR.
}
\description{
\code{testPosteriors} computes posterior probabilities of FR (functionality
        of regulatory variant) given G (genomic annotations) and E (outlier
        status) with estimate of beta (parameters between FR and G) and
        theta (parameters between FR and E).
}
\examples{
dataInput <- getData(filename=system.file("extdata", "simulation_RIVER.gz",
        package = "RIVER"), ZscoreThrd=1.5)
Feat <- scale(t(Biobase::exprs(dataInput))) # genomic features (G)
Out <- as.vector(as.numeric(unlist(dataInput$Outlier))-1) # outlier status (E)
theta.init <- matrix(c(.99, .01, .3, .7), nrow=2)
costs <- c(100, 10, 1, .1, .01, 1e-3, 1e-4)
logisticAllCV <- glmnet::cv.glmnet(Feat, Out, lambda=costs, family="binomial",
        alpha = 0, nfolds=10)
emModelAll <- integratedEM(Feat, Out, logisticAllCV$lambda.min, logisticAllCV$glmnet.fit,
        pseudoc=50, theta.init, costs, verbose=FALSE)
trainedpost <- testPosteriors(Feat, Out, emModel=emModelAll)

}
\seealso{
\code{\link{getFuncRvFeat}} and \code{\link{getFuncRvPosteriors}}
}
\author{
Yungil Kim, \email{ipw012@gmail.com}
}
