% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appRIVER.R
\name{appRIVER}
\alias{appRIVER}
\title{Application of RIVER}
\usage{
appRIVER(dataInput, pseudoc = 50, theta_init = matrix(c(0.99, 0.01, 0.3,
  0.7), nrow = 2), costs = c(100, 10, 1, 0.1, 0.01, 0.001, 1e-04),
  verbose = FALSE)
}
\arguments{
\item{dataInput}{An object of ExpressionSet class which contains input data
required for all functions in RIVER including genomic features,
outlier status, and N2 pairs.}

\item{pseudoc}{Pseudo count.}

\item{theta_init}{Initial values of theta.}

\item{costs}{Candidate penalty parameter values for L2-regularized logistic
regression.}

\item{verbose}{Logical option for showing extra information on progress.}
}
\value{
A list which contains subject IDs, gene names, posterior
        probabilities from GAM and RIVER, and estimated parameters from
        RIVER with used hyperparameters.
}
\description{
\code{appRIVER} trains RIVER with all instances and computes posterior
        probabilities of FR for downstream analyses.
}
\section{Warning}{
 To input a vector of candidate penalty values makes
        \code{glmnet} faster than to input a single penalty value
}

\examples{
dataInput <- getData(filename=system.file("extdata", "simulation_RIVER.gz",
        package = "RIVER"), ZscoreThrd=1.5)
postprobs <- appRIVER(dataInput, verbose=TRUE)

}
\seealso{
\code{\link[glmnet]{cv.glmnet}}, \code{\link{predict}},
        \code{\link{integratedEM}}, \code{\link{testPosteriors}},
        \code{\link{getData}}, \code{\link[Biobase]{exprs}}
}
\author{
Yungil Kim, \email{ipw012@gmail.com}
}
