% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dataformating.R
\name{graph2json}
\alias{graph2json}
\title{Generates JSON string correponding the the graph description}
\usage{
graph2json(ndf, edf, innerValues = NULL, innerColors = NULL,
  innerTexts = NULL, starplotColors = NULL, starplotValues = NULL,
  starplotLabels = NULL, starplotTooltips = NULL, starplotUrlLinks = NULL,
  starplotSectorStartRad = NULL, starplotCircleFillColor = NULL,
  starplotCircleFillOpacity = NULL)
}
\arguments{
\item{ndf}{A \code{data.frame} correponding to nodes definition}

\item{edf}{A \code{data.frame} correponding to edges definition}

\item{innerValues}{A \code{matrix} of numerical values for plotting
in the node}

\item{innerColors}{A \code{matrix} of string colors values for plotting
in the node}

\item{innerTexts}{A \code{matrix} of strings for plotting in the node}

\item{starplotColors}{A \code{matrix} of hex RGB colors for sectors colors}

\item{starplotValues}{A \code{matrix} of [0,1] values for starpot sectors
size}

\item{starplotLabels}{A \code{matrix} of labels identifying the sectors}

\item{starplotTooltips}{A \code{matrix} of text or even html content for
the sectors tooltips}

\item{starplotUrlLinks}{A \code{matrix} of text for the sectors url links}

\item{starplotSectorStartRad}{A \code{matrix} with a single column of
[0,2PI] values for the sector start in radians}

\item{starplotCircleFillColor}{A \code{matrix} of hex RGB colors for
the circle background}

\item{starplotCircleFillOpacity}{A \code{matrix} of [0.0,1.0] values for
the circle background opacity}
}
\value{
A JSON string with formatting
}
\description{
Generates JSON string correponding the the graph description
}
\examples{
v <- c(0, 0, 1, 1, 0,
       0, 0, 0, 0, 0,
      -1, 0, 0, 1, 0)
a <- matrix(v, 3, 5)
colnames(a) <- LETTERS[1:5]
rownames(a) <- LETTERS[1:3]

nGlobal <- list(color="#dedeff")
nProp <- data.frame(shape=c('triangle', 'lozenge'))
rownames(nProp) <- c('C', 'E')
ndf <-getNodesDataFrame(A=a, nGlobal=nGlobal, nProp=nProp)

eGlobal <- list(color="#5555ff")
eProp <- data.frame(from=c('A','C'), to=c('B', 'A'), width=c(2,2))
edf <- getEdgesDataFrame(A=a, eGlobal=eGlobal, eProp=eProp)

graph2json(ndf=ndf, edf=edf)
}
\author{
Sylvain Gubian \email{DL.RSupport@pmi.com}
}

